/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.statement;

import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.TestSObjectTypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ForEachStatementTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"for (String a : new List<Integer>()) {}", I18nSupport.getLabel("invalid.loop.type", TypeInfos.INTEGER, TypeInfos.STRING)}, {"for (SObject a : 'foo') {}", I18nSupport.getLabel("loop.must.iterate.over.collection", TypeInfos.STRING)}, {"for (SObject a : [SELECT count() FROM Account]) {}", I18nSupport.getLabel("loop.must.iterate.over.collection", TypeInfos.INTEGER)}, {"for (Account a : [SELECT x FROM Account]);", I18nSupport.getLabel("loop.with.query.requires.statement")}, {"for (Account a : Database.query(''));", I18nSupport.getLabel("loop.with.query.requires.statement")}, {"Account account; for (Account a : account.getSObjects(''));", I18nSupport.getLabel("loop.with.query.requires.statement")}, {"Schema.SObjectField o; Account account; for (Account a : account.getSObjects(o));", I18nSupport.getLabel("loop.with.query.requires.statement")}, {"for (List<Contact> a : [SELECT Id FROM Account]) {}", I18nSupport.getLabel("loop.variable.mismatch.concrete.sobject.type", TestSObjectTypeInfos.ACCOUNT)}, {"for (Contact a : [SELECT Id FROM Account]) {}", I18nSupport.getLabel("loop.variable.mismatch.concrete.sobject.type", TestSObjectTypeInfos.ACCOUNT)}, {"for (String a : Database.query('SELECT Id FROM Account')) {}", I18nSupport.getLabel("loop.variable.mismatch.sobject.type")}, {"for (Set<String> a : Database.query('SELECT Id FROM Account')) {}", I18nSupport.getLabel("loop.variable.mismatch.sobject.type")}, {"Account account; for (String a : account.getSObjects('')) {}", I18nSupport.getLabel("loop.variable.mismatch.sobject.type")}, {"Account account; for (List<String> a : account.getSObjects('')) {}", I18nSupport.getLabel("loop.variable.mismatch.sobject.type")}, {"Schema.SObjectField o; Account account; for (String a : account.getSObjects(o)) {}", I18nSupport.getLabel("loop.variable.mismatch.sobject.type")}, {"Schema.SObjectField o; Account account; for (List<String> a : account.getSObjects(o)) {}", I18nSupport.getLabel("loop.variable.mismatch.sobject.type")}, {"for (foo : new List<Integer>()) {} ", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"for (foo i : new List<Integer>()) {} ", I18nSupport.getLabel("invalid.unresolved.type", "foo")}, {"for (Integer i : new List<foo>()) {} ", I18nSupport.getLabel("invalid.unresolved.type", "foo")}, {"for (Integer i : new List<Integer>()) { foo a; } ", I18nSupport.getLabel("invalid.unresolved.type", "foo")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"String a; for (a : new Set<String>());"}, {"for (String a : new List<String>()) {}"}, {"for (String a : new List<String>());"}, {"for (Object a : new List<String>()) {}"}, {"for (List<Account> a : [SELECT Id FROM Account]) {}"}, {"for (Account a : [SELECT Id FROM Account]) {}"}, {"for (List<SObject> a : [SELECT Id FROM Account]) {}"}, {"for (SObject a : [SELECT Id FROM Account]) {}"}, {"for (List<Account> a : Database.query('SELECT Id FROM Account')) {}"}, {"for (Account a : Database.query('SELECT Id FROM Account')) {}"}, {"for (List<SObject> a : Database.query('SELECT Id FROM Account')) {}"}, {"for (SObject a : Database.query('SELECT Id FROM Account')) {}"}, {"Account account; for (Contact a : account.getSObjects('')) {}"}, {"Account account; for (List<Contact> a : account.getSObjects('')) {}"}, {"Schema.SObjectField o; Account account; for (Contact a : account.getSObjects(o)) {}"}, {"Schema.SObjectField o; Account account; for (List<Contact> a : account.getSObjects(o)) {}"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }
}

