/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.statement;

import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DmlUndeleteStatementTest {
    private ValidationTester tester;

    @BeforeTest
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"undelete 5;", I18nSupport.getLabel("invalid.dml.type", TypeInfos.INTEGER)}, {"undelete foo;", I18nSupport.getLabel("variable.does.not.exist", "foo")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalidData(String source, String expectError) {
        this.tester.assertFailure(source, expectError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"Account a; undelete a;"}, {"List<Account> l; undelete l;"}};
    }

    @Test(dataProvider="validData")
    public void testValidData(String source) {
        this.tester.assertSuccess(source);
    }
}

