/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.statement;

import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DmlMergeStatementTest {
    private ValidationTester tester;

    @BeforeTest
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"Account a; merge a 5;", I18nSupport.getLabel("invalid.merge.duplicate.records")}, {"merge 5 5;", I18nSupport.getLabel("merge.requires.concrete.type", TypeInfos.INTEGER)}, {"SObject obj1; SObject obj2; merge obj1 obj2;", I18nSupport.getLabel("merge.requires.concrete.type", TypeInfos.SOBJECT)}, {"Account a; merge a foo;", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"Account a; merge foo a;", I18nSupport.getLabel("variable.does.not.exist", "foo")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalidData(String source, String expectedError) {
        this.tester.assertFailure(source, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"Account a1; Account a2; merge a1 a2;"}, {"Account a1; List<Account> l1; merge a1 l1;"}, {"Account a1; List<String> l1; merge a1 l1;"}, {"Account a1; List<Id> l1; merge a1 l1;"}};
    }

    @Test(dataProvider="validData")
    public void testValidData(String source) {
        this.tester.assertSuccess(source);
    }
}

