/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.statement;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DmlInsertStatementTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"insert 5;", I18nSupport.getLabel("invalid.dml.type", TypeInfos.INTEGER)}, {"insert foo;", I18nSupport.getLabel("variable.does.not.exist", "foo")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalidData(String source, String expectedError) {
        this.tester.assertFailure(source, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"Account a; insert a;"}, {"List<Account> l; insert l;"}, {"User u; insert u;"}};
    }

    @Test(dataProvider="validData")
    public void testValidData(String source) {
        this.tester.assertSuccess(source);
    }

    @DataProvider
    Object[][] validTrustedData() {
        return new Object[][]{{"trigger Foo on Account (before insert) { List<BusinessHours> bh; insert bh; }"}};
    }

    @Test(dataProvider="validTrustedData")
    public void testFileBasedTriggerInsert(String code) {
        this.tester.setTrusted(true);
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess(code);
    }
}

