/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.modifier;

import apex.jorje.semantic.ast.modifier.rule.Element;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class RemoteActionRuleTest
extends ValidationTest {
    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"public class Foo{ @RemoteAction static String m(){ return 'a'; } }", I18nSupport.getLabel("modifier.requires.at.least", new Object[]{AnnotationTypeInfos.REMOTE_ACTION, Element.METHOD, ModifierTypeInfos.GLOBAL + ", " + ModifierTypeInfos.PUBLIC})}, {"public class Foo{ @RemoteAction public String m(){ return 'a'; } }", I18nSupport.getLabel("modifier.requires", new Object[]{AnnotationTypeInfos.REMOTE_ACTION, Element.METHOD, ModifierTypeInfos.STATIC})}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"public class Foo{ @RemoteAction public static List<String> m(){ return new List<String>(); } }"}, {"public class Foo{ @RemoteAction public static Object m(){ return null; } }"}, {"public class Foo{ @RemoteAction public static Object m(Map<String, Object> pars){ return null; } }"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }

    @DataProvider
    Object[][] invalidVersionData() {
        return new Object[][]{{"public class Foo{ @RemoteAction public static String m(){ return 'a'; } }", I18nSupport.getLabel("modifier.min.version", new Object[]{AnnotationTypeInfos.REMOTE_ACTION, Element.METHOD, Version.V170.toExternal()})}};
    }

    @Test(dataProvider="invalidVersionData")
    public void testInvalidVersionData(String code, String expectedError) {
        this.tester.setVersion(Version.MIN);
        this.tester.assertFailure(code, expectedError);
    }

    @Test
    public void testInvalidPerm() {
        this.tester.getAccessEvaluator().setHasRemoteActionPerm(false);
        this.tester.assertFailure("public class Foo{ @RemoteAction public static String m(){ return 'a'; } }", I18nSupport.getLabel("annotation.not.supported", AnnotationTypeInfos.REMOTE_ACTION));
    }

    @Test
    public void testInvalidPublicMethodInGlobalComponent() {
        this.tester.getAccessEvaluator().setGlobalComponent("Foo");
        this.tester.assertFailure("public class Foo{ @RemoteAction public static String m(){ return 'a'; } }", I18nSupport.getLabel("invalid.public.remote.action"));
    }
}

