/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.modifier;

import apex.jorje.semantic.ast.modifier.rule.Element;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ReadOnlyTest
extends ValidationTest {
    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"global class Foo { @ReadOnly static Integer m() { return 0; } }", I18nSupport.getLabel("modifier.requires.at.least", new Object[]{AnnotationTypeInfos.READ_ONLY, Element.METHOD, ModifierTypeInfos.WEB_SERVICE + ", " + AnnotationTypeInfos.REMOTE_ACTION})}, {"global class Foo { @ReadOnly void execute(SchedulableContext ctx) {} }", I18nSupport.getLabel("invalid.read.only")}, {"global class Foo implements Schedulable{ @ReadOnly void execute() {} global void execute(SchedulableContext ctx) {} }", I18nSupport.getLabel("invalid.read.only")}, {"global class Foo implements Schedulable{ @ReadOnly void foo(SchedulableContext ctx) {} global void execute(SchedulableContext ctx) {} }", I18nSupport.getLabel("invalid.read.only")}, {"global class Foo implements Schedulable{ @ReadOnly void execute(Integer i) {} global void execute(SchedulableContext ctx) {} }", I18nSupport.getLabel("invalid.read.only")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"global class Foo { @ReadOnly WebService static Integer m() { return 0; } }"}, {"global class Foo { @ReadOnly @RemoteAction static global Integer m() { return 0; } }"}, {"global class Foo implements Schedulable{ @ReadOnly global void execute(SchedulableContext ctx) {} }"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }
}

