/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.modifier;

import apex.jorje.semantic.ast.modifier.rule.Element;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class IsTestRuleTest
extends ValidationTest {
    @DataProvider
    Object[][] invalidIsTestData() {
        return new Object[][]{{"public class Foo{ @IsTest public class FooTest {} }", I18nSupport.getLabel("modifier.not.on.top.level.type", AnnotationTypeInfos.IS_TEST)}, {"@IsTest public virtual class Foo{}", I18nSupport.getLabel("modifier.cannot.be", new Object[]{AnnotationTypeInfos.IS_TEST, Element.CLASS, ModifierTypeInfos.VIRTUAL})}, {"@IsTest global class Foo{@IsTest(SeeAllData=true) public static void testA() {} @TestSetup public static void testB() {}}", I18nSupport.getLabel("test.setup.cannot.have.see.all.data")}, {"@IsTest class TestException extends Exception { }", I18nSupport.getLabel("test.class.must.not.be.exception")}, {"public class MyTest { static testMethod void test1(){} }", I18nSupport.getLabel("modifier.requires", new Object[]{I18nSupport.getLabel("modifier.illegal.defining.type.for", ModifierTypeInfos.TEST_METHOD), Element.METHOD, AnnotationTypeInfos.IS_TEST})}, {"@IsTest public class MyTest { static testMethod void test1(String case) {} }", I18nSupport.getLabel("test.method.cannot.have.params")}};
    }

    @Test(dataProvider="invalidIsTestData")
    public void testInvalidIsTest(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validIsTestData() {
        return new Object[][]{{"@IsTest private class Foo {}"}, {"@IsTest class Foo {}"}, {"@IsTest(SeeAllData=true) public class Foo {}"}, {"@IsTest(SeeAllData=false) public class Foo { @TestSetup public static void Method1() {}}"}, {"@IsTest public class Foo { @TestSetup public static void Method1() {}}"}, {"@IsTest public class MyTest { static testMethod void test1(){} }"}};
    }

    @Test(dataProvider="validIsTestData")
    public void testValidIsTest(String code) {
        this.tester.assertSuccess(code);
    }

    @DataProvider
    Object[][] validIsTestVersionData() {
        return new Object[][]{{"@IsTest private class Foo { @IsTest public static void testA() {} }", Version.V170}};
    }

    @Test(dataProvider="validIsTestVersionData")
    public void testValidIsTestVersionData(String code, Version version) {
        this.tester.setVersion(version);
        this.tester.assertSuccess(code);
    }

    @DataProvider
    Object[][] invalidIsTestVersionData() {
        return new Object[][]{{"@IsTest(SeeAllData=true) public class FooTest {}", Version.V170, I18nSupport.getLabel("annotation.property.min.version", "seeAllData", AnnotationTypeInfos.IS_TEST, Version.V174.toExternal())}};
    }

    @Test(dataProvider="invalidIsTestVersionData")
    public void testInvalidIsTestVersion(String code, Version version, String expectedError) {
        this.tester.setVersion(version);
        this.tester.assertFailure(code, expectedError);
    }
}

