/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.modifier;

import apex.jorje.semantic.ast.modifier.rule.Element;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class HttpRequestRuleTest
extends ValidationTest {
    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"@RestResource(urlMapping='/myRestAPI/*') public class Foo{}", I18nSupport.getLabel("modifier.requires", new Object[]{AnnotationTypeInfos.REST_RESOURCE, Element.CLASS, ModifierTypeInfos.GLOBAL})}, {"@RestResource(urlMapping='/myRestAPI/*') global class Foo{ @httpGet  global static Set<Integer> m(){return new Set<Integer>();} }", I18nSupport.getLabel("method.does.not.support.return.type", AnnotationTypeInfos.HTTP_GET, "Set<Integer>")}, {"@RestResource(urlMapping='/myRestAPI/*') global class Foo{ @httpGet  global static Map<Integer,Integer> m(){return new Map<Integer,Integer>();} }", I18nSupport.getLabel("method.does.not.support.return.type", AnnotationTypeInfos.HTTP_GET, "Map<Integer, Integer>")}, {"@RestResource(urlMapping='/myRestAPI/*') global class Foo{ @HttpPut global void m(){} }", I18nSupport.getLabel("modifier.requires", new Object[]{AnnotationTypeInfos.HTTP_PUT, Element.METHOD, ModifierTypeInfos.STATIC})}, {"@RestResource(urlMapping='/myRestAPI/*') global class Foo{ @HttpPut static void m(String urlParam1, String urlParam2){} }", I18nSupport.getLabel("modifier.requires", new Object[]{AnnotationTypeInfos.HTTP_PUT, Element.METHOD, ModifierTypeInfos.GLOBAL})}, {"@RestResource(urlMapping='/myRestAPI/*') @IsTest global class Foo{ @httpPatch global static testMethod void m(){} }", I18nSupport.getLabel("modifier.cannot.be", new Object[]{AnnotationTypeInfos.HTTP_PATCH, Element.METHOD, ModifierTypeInfos.TEST_METHOD})}, {"@RestResource(urlMapping='/myRestAPI/*') global class Foo{ @httpDelete @future  global static void m(){} }", I18nSupport.getLabel("modifier.cannot.be", new Object[]{AnnotationTypeInfos.HTTP_DELETE, Element.METHOD, AnnotationTypeInfos.FUTURE})}, {"@RestResource(urlMapping='/myRestAPI/*') global class Foo{ @httpGet global static void m(String param){} }", I18nSupport.getLabel("invalid.method.with.parameters", AnnotationTypeInfos.HTTP_GET)}, {"global class Foo{ @httpGet global static void m(){} }", I18nSupport.getLabel("modifier.requires", new Object[]{I18nSupport.getLabel("modifier.illegal.defining.type.for", AnnotationTypeInfos.HTTP_GET), Element.METHOD, AnnotationTypeInfos.REST_RESOURCE})}, {"@RestResource(urlMapping='/myRestAPI/*') global class Foo{ @httpGet  global static void m(){} @httpGet  global static void m1(){}}", I18nSupport.getLabel("invalid.multiple.methods.with.modifier", AnnotationTypeInfos.HTTP_GET)}, {"@RestResource(urlMapping='/myRestAPI/*') global class Foo{ @httpPost  global static void m(){} @httpPost  global static void m1(){}}", I18nSupport.getLabel("invalid.multiple.methods.with.modifier", AnnotationTypeInfos.HTTP_POST)}, {"@RestResource(urlMapping='/myRestAPI/*') global class Foo{ @httpPut  global static void m(){} @httpPut  global static void m1(){}}", I18nSupport.getLabel("invalid.multiple.methods.with.modifier", AnnotationTypeInfos.HTTP_PUT)}, {"@RestResource(urlMapping='/myRestAPI/*') global class Foo{ @httpPatch  global static void m(){} @httpPatch  global static void m1(){}}", I18nSupport.getLabel("invalid.multiple.methods.with.modifier", AnnotationTypeInfos.HTTP_PATCH)}, {"@RestResource(urlMapping='/myRestAPI/*') global class Foo{ @httpDelete  global static void m(){} @httpDelete  global static void m1(){}}", I18nSupport.getLabel("invalid.multiple.methods.with.modifier", AnnotationTypeInfos.HTTP_DELETE)}, {"public class Foo{ @RestResource(urlMapping='/myRestAPI/*') Integer num; }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{AnnotationTypeInfos.REST_RESOURCE, Element.FIELD})}, {"public class Foo{ @HttpGet Integer num; }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{AnnotationTypeInfos.HTTP_GET, Element.FIELD})}, {"public class Foo{ @HttpDelete Integer num; }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{AnnotationTypeInfos.HTTP_DELETE, Element.FIELD})}, {"public class Foo{ @HttpPut Integer num; }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{AnnotationTypeInfos.HTTP_PUT, Element.FIELD})}, {"public class Foo{ @HttpPost Integer num; }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{AnnotationTypeInfos.HTTP_POST, Element.FIELD})}, {"public class Foo{ @HttpPatch  Integer num; }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{AnnotationTypeInfos.HTTP_PATCH, Element.FIELD})}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"@RestResource(urlMapping='/myRestAPI/*') global class Foo{ @HttpPost global static List<Integer> m(){return new List<Integer>();} }"}, {"@RestResource(urlMapping='/myRestAPI/*') global class Foo{ @HttpPatch global static Map<String,Integer> m(){return new Map<String,Integer>();} }"}, {"@RestResource(urlMapping='/myRestAPI/*') global class Foo{ @HttpDelete global static void m(){} }"}, {"@RestResource(urlMapping='/myRestAPI/*') global class Foo{ @HttpGet global static void m(){} }"}, {"@RestResource(urlMapping='/myRestAPI/*') global class Foo{ @HttpPut global static void m(Foo f) {} }"}, {"@RestResource(urlMapping='/myRestAPI/*') global class Foo{ @HttpPut global static Foo m() { return null; } }"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }

    @Test
    public void testVersion() {
        this.tester.setVersion(Version.V170);
        this.tester.assertFailure("@RestResource(urlMapping='/myRestAPI/*') global class Foo { }", I18nSupport.getLabel("modifier.min.version", new Object[]{AnnotationTypeInfos.REST_RESOURCE, Element.CLASS, Version.V172.toExternal()}));
    }

    @Test
    public void testReservedNamespaceNotAllowed() {
        this.tester.getAccessEvaluator().addReservedNamespace(Namespaces.SYSTEM);
        this.tester.assertFailure("@RestResource(urlMapping='/myRestAPI/*') global class Foo { @HttpPut global static  void m(System.Iterable<Integer> i) {} }", I18nSupport.getLabel("method.does.not.support.parameter.type", AnnotationTypeInfos.HTTP_PUT, "System.Iterable<Integer>"));
    }
}

