/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.modifier;

import apex.jorje.semantic.ast.modifier.rule.Element;
import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FieldRuleGroupTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"public class Foo{ abstract Integer num; }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{ModifierTypeInfos.ABSTRACT, Element.FIELD})}, {"public class Foo{ override Integer num; }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{ModifierTypeInfos.OVERRIDE, Element.FIELD})}, {"public class Foo{ @ReadOnly Integer num; }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{AnnotationTypeInfos.READ_ONLY, Element.FIELD})}, {"public class Foo{ static testMethod Integer num; }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{ModifierTypeInfos.TEST_METHOD, Element.FIELD})}, {"public class Foo{ with sharing Integer num; }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{ModifierTypeInfos.WITH_SHARING, Element.FIELD})}, {"public class Foo{ without sharing Integer num; }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{ModifierTypeInfos.WITHOUT_SHARING, Element.FIELD})}, {"global class Foo{ @deprecated global class Bar{} global Bar barObj; } ", I18nSupport.getLabel("global.deprecate.if.type.deprecated", "Foo.Bar")}, {"public class Foo { private public String str; }", I18nSupport.getLabel("declarations.single.scope")}, {"public class Foo{ class Bar { static String str; } }", I18nSupport.getLabel("modifier.not.in.top.level.type", new Object[]{ModifierTypeInfos.STATIC, Element.FIELD})}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] invalidTrustedData() {
        return new Object[][]{{"@SfdcOnly global class Foo{ global  Integer num; }", I18nSupport.getLabel("sfdc.only.cannot.have.global.fields")}};
    }

    @Test(dataProvider="invalidTrustedData")
    public void testInvalidTrusted(String code, String expectedError) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.setTrusted(true);
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"global class Foo{ global Integer num; }"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess(code);
    }
}

