/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.modifier;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AnnotationTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"@Foo void foo() {}", I18nSupport.getLabel("invalid.unresolved.annotation", "Foo")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"@Foo('bar') void foo() {}"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }

    @Test
    public void testIllegalAnnotationValueType() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure("@isTest(SeeAllData=6) public class Foo {}", I18nSupport.getLabel("unexpected.token", "6"), I18nSupport.getLabel("annotation.property.invalid.value", "SeeAllData", "BOOLEAN"));
    }

    @Test
    public void testDeprecatedOnClass() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess("@deprecated() global class Foo {}");
    }
}

