/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.member;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class MethodTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"public class Foo { void trigger() {} }", I18nSupport.getLabel("invalid.keyword.identifier", "trigger")}, {"public abstract class Foo { abstract void method1() { System.debug('12');} }", I18nSupport.getLabel("abstract.methods.cannot.have.body")}, {"public class Foo { void foo(Integer i1, Integer i2, Integer i3, Integer i4, Integer i5, Integer i6, Integer i7, Integer i8, Integer i9, Integer i10, Integer i11, Integer i12, Integer i13, Integer i14, Integer i15, Integer i16, Integer i17, Integer i18, Integer i19, Integer i20, Integer i21, Integer i22, Integer i23, Integer i24, Integer i25, Integer i26, Integer i27, Integer i28, Integer i29, Integer i30, Integer i31, Integer i32, Integer i33) {}}", I18nSupport.getLabel("invalid.number.parameters", 32)}, {"public class Foo { public void() {} }", I18nSupport.getLabel("invalid.constructor.name", "void")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"public abstract class Foo{ abstract void method1(); }"}, {"public class Foo{ static void m() {} { Foo.m();} }"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess(code);
    }
}

