/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class VariableExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidAnonymousData() {
        return new Object[][]{{"foo i;", I18nSupport.getLabel("invalid.unresolved.type", "foo")}, {"Integer i = load;", I18nSupport.getLabel("variable.does.not.exist", "load")}, {"store = 1;", I18nSupport.getLabel("variable.does.not.exist", "store")}, {"Account a = [select id from account where id = :x];", I18nSupport.getLabel("variable.does.not.exist", "x")}, {"foo.bar = 1;", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"foo.bar();", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"new Map<String, Integer>(i);", I18nSupport.getLabel("variable.does.not.exist", "i")}, {"new List<String>(i);", I18nSupport.getLabel("variable.does.not.exist", "i")}, {"new Set<String>(i);", I18nSupport.getLabel("variable.does.not.exist", "i")}, {"try { Integer i; } catch (Exception x) { i = 1; } finally { } ", I18nSupport.getLabel("variable.does.not.exist", "i")}, {"try { } catch (Exception x) { Integer i; } finally { i = 1;} ", I18nSupport.getLabel("variable.does.not.exist", "i")}, {"try { } catch (Exception x) { } finally { x = 1; } ", I18nSupport.getLabel("variable.does.not.exist", "x")}, {"{ Integer i = j; Integer j; }", I18nSupport.getLabel("variable.does.not.exist", "j")}, {"Foo i; i = null;", I18nSupport.getLabel("invalid.unresolved.type", "Foo")}, {"Foo i, j; i = j;", I18nSupport.getLabel("invalid.unresolved.type", "Foo")}, {"{ Foo i; i = null; }", I18nSupport.getLabel("invalid.unresolved.type", "Foo")}, {"{ Foo i, j; i = j; }", I18nSupport.getLabel("invalid.unresolved.type", "Foo")}};
    }

    @Test(dataProvider="invalidAnonymousData")
    public void testInvalidAnonymous(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] invalidNamedData() {
        return new Object[][]{{"public class Foo { static final Integer i; void bar() { i = 5; } }", I18nSupport.getLabel("invalid.final.field.assignment", "i")}, {"public class Foo { final Integer i; void bar() { i = 5; } }", I18nSupport.getLabel("invalid.final.field.assignment", "i")}, {"public class Foo { Integer i; class InnerFoo { { i = 0; } } }", I18nSupport.getLabel("variable.does.not.exist", "i")}, {"public class Foo { Integer i; { Foo.i = 1; } }", I18nSupport.getLabel("variable.does.not.exist", "i")}, {"public class Foo { static Integer i; { new Foo().i = 1; } }", I18nSupport.getLabel("invalid.static.variable.context", "i", "Foo")}, {"public class Foo { Integer i; static { i = 1; } }", I18nSupport.getLabel("variable.does.not.exist", "i")}, {"public class Foo { Integer i; { Integer j = Foo.i; } }", I18nSupport.getLabel("variable.does.not.exist", "i")}, {"public class Foo { static Integer i; { Integer j = new Foo().i; } }", I18nSupport.getLabel("invalid.static.variable.context", "i", "Foo")}, {"public class Foo { Integer i; static { Integer j = i; } }", I18nSupport.getLabel("variable.does.not.exist", "i")}};
    }

    @Test(dataProvider="invalidNamedData")
    public void testInvalidNamed(String code, String expectedError) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validAnonymousData() {
        return new Object[][]{{"static Integer staticI; Integer i; class Foo { { staticI = 0; i = 0; } }"}};
    }

    @Test(dataProvider="validAnonymousData")
    public void testValidAnonymousData(String code) {
        this.tester.assertSuccess(code);
    }

    @DataProvider
    Object[][] validNamedData() {
        return new Object[][]{{"public class Type {\n   Integer foo; \n   static Integer foo; \n   static { \n       Integer i = foo;\n   }\n   {\n       Integer i = foo;\n       Integer j = Type.foo;\n   }\n}"}, {"public class Type {\n   final Integer foo = 0; \n   static final Integer staticFoo = 0; \n   static { \n       staticFoo = 0; \n   }\n   {\n       staticFoo = 0;\n       foo = 0; \n   }\n   Type() {\n       staticFoo = 5;\n       foo = 5;\n   }\n   {\n       new Type().foo = 5;       Type.staticFoo = 5;   }\n}"}, {"public class Foo { static Integer i; class InnerFoo { { i = 0; } } }"}, {"public class Foo { static Integer i; { i = 1; } }"}};
    }

    @Test(dataProvider="validNamedData")
    public void testValid(String code) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess(code);
    }

    @Test
    public void testInaccessibleTypeLoad() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(ImmutableList.of("public class Foo { private class InnerFoo { } public InnerFoo someProp { get; } }", "public class Bar { { Foo f; Object o = f.someProp; } }"), ImmutableList.of(I18nSupport.getLabel("type.not.visible", "Foo.InnerFoo")));
    }

    @Test
    public void testInaccessibleTypeStore() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(ImmutableList.of("public class Foo { private class InnerFoo { } public InnerFoo someProp { set; } }", "public class Bar { { Foo f; f.someProp = null; } }"), ImmutableList.of(I18nSupport.getLabel("type.not.visible", "Foo.InnerFoo")));
    }
}

