/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TriggerVariableExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
        this.tester.setParserType(ParserWrapper.Type.NAMED);
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"trigger Foo on Custom__c(before update) {}", I18nSupport.getLabel("invalid.unresolved.type", "Schema.Custom__c")}, {"trigger Foo on Contact(after insert) { SObject s = Trigger.oldRecord; }", I18nSupport.getLabel("variable.does.not.exist", "oldRecord")}, {"trigger Foo on Contact(after insert) { Boolean b = Trigger.done; }", I18nSupport.getLabel("variable.does.not.exist", "done")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"trigger Foo on Account(before delete) { Boolean b = Trigger.isInsert; } "}, {"trigger Foo on Account(after update) { Boolean b = Trigger.isUpdate; } "}, {"trigger Foo on Account(before insert) { Boolean b = Trigger.isDelete; } "}, {"trigger Foo on Account(before delete) { Boolean b = Trigger.isUndelete; } "}, {"trigger Foo on Account(after undelete) { Boolean b = Trigger.isExecuting; } "}, {"trigger Foo on Account(before update) { Boolean b = Trigger.isBefore; } "}, {"trigger Foo on Account(after insert) { Boolean b = Trigger.isAfter; } "}, {"trigger Foo on Account(before delete) { List<SObject> lst = Trigger.old; } "}, {"trigger Foo on Account(before delete) { List<SObject> lst = Trigger.new; } "}, {"trigger Foo on Account(before delete) { Map<Id,SObject> oldMap = Trigger.oldMap; } "}, {"trigger Foo on Account(before delete) { Map<Id,SObject> newMap = Trigger.newMap; } "}, {"trigger Foo on Account(before delete) { Integer count = Trigger.size; } "}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }

    @Test
    public void testOverrideAccount() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess("public class Account { }", "trigger Foo on Account(before delete) { Boolean b = Trigger.isInsert; } ");
    }
}

