/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ThisExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
        this.tester.setParserType(ParserWrapper.Type.NAMED);
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"public class foo { { this(); } }", I18nSupport.getLabel("invalid.this.call")}, {"public class foo { void bar() { this(); } }", I18nSupport.getLabel("invalid.this.call")}, {"public class foo { foo() { { this(); } } }", I18nSupport.getLabel("invalid.this.call")}, {"public class foo { foo() { Integer i; this(); } }", I18nSupport.getLabel("invalid.this.call")}, {"public class foo { foo() { Foo i = this(); } }", I18nSupport.getLabel("invalid.this.call")}, {"public class foo { Integer i; static { this.i = 5; } }", I18nSupport.getLabel("invalid.this.static.context")}, {"public class foo { Integer i; foo() { this(i); } foo (Integer i) {} }", I18nSupport.getLabel("illegal.instance.variable.reference.in.constructor", "i")}, {"public class foo { Integer i; foo() { this(++i); } foo (Integer i) {} }", I18nSupport.getLabel("illegal.instance.variable.reference.in.constructor", "i")}, {"public class foo { foo() { this(bar()); } foo (Integer i) {} Integer bar() { return 0; } }", I18nSupport.getLabel("illegal.instance.method.reference.in.constructor", "Integer foo.bar()")}, {"public class foo { foo() { this(this.bar()); } foo (Integer i) {} Integer bar() { return 0; } }", I18nSupport.getLabel("illegal.instance.variable.reference.in.constructor", "this")}, {"public virtual class bar { public class foo extends bar { foo() { this(super.bar()); } foo (Integer i) {} } Integer bar() { return 0; } }", I18nSupport.getLabel("illegal.instance.variable.reference.in.constructor", "super")}, {"public class foo { Foo instance; foo() { this(instance.instance); } foo(Foo f) {} } ", I18nSupport.getLabel("illegal.instance.variable.reference.in.constructor", "instance")}, {"public class foo { Integer i; foo() { this(i = 1); } foo(Integer i) {} } ", I18nSupport.getLabel("illegal.instance.variable.reference.in.constructor", "i")}, {"public class foo { Integer i; foo() { this(+(i = 1)); } foo (Integer i) {} }", I18nSupport.getLabel("illegal.instance.variable.reference.in.constructor", "i")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"public class foo { foo() { this(); } }"}, {"public class foo { Integer i; { this.i = 5; } }"}, {"public class foo { void bar() {} { this.bar(); } }"}, {"public class foo { Integer i; foo() {} foo (Integer i) { this(i); } }"}, {"public class foo { Integer i; foo() { this(new foo().i); } foo (Integer i) {} }"}, {"public class foo { foo() { this(new foo().bar()); } foo (Integer i) {} Integer bar() { return 0; } }"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }
}

