/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.TestQueryValidators;
import apex.jorje.semantic.tester.TestSObjectTypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SoqlExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"List<Account> aList = [select id from Account where id =:myId];", I18nSupport.getLabel("variable.does.not.exist", "myId")}, {"List<SObject> aList = [select id from MyUnknownCustomObject__c];", I18nSupport.getLabel("invalid.unresolved.type", "Schema.MyUnknownCustomObject__c")}, {"List<SObject> aList = [SELECT CampaignId FROM Opportunity GROUP By CampaignId FOR UPDATE];", I18nSupport.getLabel("invalid.row.lock", TestSObjectTypeInfos.AGGREGATE_RESULT)}, {"List<SObject> aList = [SELECT AVG(amount) FROM Opportunity FOR UPDATE];", I18nSupport.getLabel("invalid.row.lock", TestSObjectTypeInfos.AGGREGATE_RESULT)}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"Id myId; List<Account> aList = [select id from Account where id = :myId];"}, {"public id getMyId(){ return '';} List<User> aList = [select id from User where id = :getMyId()];"}, {"List<String> strList; List<Account> aList = [select id from Account where id in :strList];"}, {"Integer count = [select count() from Account];"}, {"List<AggregateResult> result = [SELECT CampaignId, AVG(Amount) FROM Opportunity GROUP BY CampaignId];"}, {"List<Account> accounts = [select id from Account where id in (select id from Contact)];"}, {"List<Contact> contacts = [select id, (select id from Contact.Account) from Contact];"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }

    @Test
    public void testQueryValidator() {
        this.tester.setQueryValidator(new TestQueryValidators.Error());
        this.tester.assertFailure("Integer count = [select count() from Account];", "Bad Soql");
    }

    @Test
    public void testOverrideAccount() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess("public class Account { }", "public class Foo { void m() {  List<Schema.Account> aList = [select id from Account]; } }");
    }
}

