/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.Test;

public class ReferenceExpressionTest
extends ValidationTest {
    @Test
    public void testIncompleteStaticBind() {
        this.tester.assertFailure(new String[]{"public class Foo { public static Foo field; }", "public class Bar { { String foo = Foo.field.badField.toString(); } }"}, I18nSupport.getLabel("variable.does.not.exist", "badField"));
    }

    @Test
    public void testBindAfterStatic() {
        this.tester.assertSuccess("public class Foo { public static Foo staticField; public foo instanceField; public string stringField; }", "public class Bar { { String str = Foo.staticField.instanceField.stringField; } }");
    }

    @Test
    public void testFieldBindToStaticTypesWithDuplicateName() {
        this.tester.assertSuccess("public class Foo { Integer foo; static Integer i; static void m() { Foo.i = 5; } }");
    }

    @Test
    public void testMethodBindToStaticTypesWithDuplicateName() {
        this.tester.assertSuccess("public class Foo { Integer foo; static void m() { Foo.m(); } }");
    }
}

