/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class PostfixExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"String s; s++;", I18nSupport.getLabel("invalid.numeric.postfix.operand", TypeInfos.STRING)}, {"Boolean b; b++;", I18nSupport.getLabel("invalid.numeric.postfix.operand", TypeInfos.BOOLEAN)}, {"foo++;", I18nSupport.getLabel("variable.does.not.exist", "foo")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"Integer i; i++;"}, {"Integer i; i--;"}, {"Double d; d++;"}, {"Double d; d--;"}, {"Decimal d; d++;"}, {"Decimal d; d--;"}, {"Long l; l++;"}, {"Long l; l--;"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }
}

