/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.StructuredVersion;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class PackageVersionExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @Test
    public void testInvalidEmptyNamespace() {
        this.tester.assertFailure("Package.Version v = Package.Version.1.0;", I18nSupport.getLabel("package.version.requires.namespace"));
    }

    @Test
    public void testInvalidPackageVersion() {
        this.tester.setNamespace(Namespaces.APEX);
        this.tester.assertFailure("Package.Version v = Package.Version.1.0;", I18nSupport.getLabel("package.version.invalid", "1.0"));
    }

    @Test
    public void testInvalidPackageVersionRequest() {
        this.tester.setNamespace(Namespaces.APEX);
        this.tester.assertFailure("Package.Version v = Package.Version.foo;", I18nSupport.getLabel("unexpected.token", "foo"));
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"Package.Version v = Package.Version.1.0;"}, {"Package.Version v = Package.Version.Request;"}};
    }

    @Test(dataProvider="validData")
    public void testValidData(String source) {
        this.tester.setNamespace(Namespaces.APEX);
        this.tester.getAccessEvaluator().addValidPackageVersion(Namespaces.APEX, new StructuredVersion(1, 0));
        this.tester.assertSuccess(source);
    }
}

