/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.collect.ImmutableList;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class NewMapLiteralExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"new Map<String, String>{true => 'b'};", new String[]{I18nSupport.getLabel("invalid.initial.key.type", TypeInfos.BOOLEAN, TypeInfos.STRING)}}, {"new Map<String, String>{'b' => true};", new String[]{I18nSupport.getLabel("invalid.initial.value.type", TypeInfos.BOOLEAN, TypeInfos.STRING)}}, {"new Map<Integer, Integer>{17L => 29L};", new String[]{I18nSupport.getLabel("invalid.initial.key.type", TypeInfos.LONG, TypeInfos.INTEGER), I18nSupport.getLabel("invalid.initial.value.type", TypeInfos.LONG, TypeInfos.INTEGER)}}, {"new Map<String, Integer> {foo => 1};", new String[]{I18nSupport.getLabel("variable.does.not.exist", "foo")}}, {"new Map<String, Integer> {'foo' => foo};", new String[]{I18nSupport.getLabel("variable.does.not.exist", "foo")}}, {"new Map<String, foo>();", new String[]{I18nSupport.getLabel("invalid.unresolved.type", "foo")}}, {"new Map<foo, Integer>();", new String[]{I18nSupport.getLabel("invalid.unresolved.type", "foo")}}, {"new Map<foo, bar>();", new String[]{I18nSupport.getLabel("invalid.unresolved.type", "foo"), I18nSupport.getLabel("invalid.unresolved.type", "bar")}}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String[] expectedErrors) {
        this.tester.assertFailure(code, expectedErrors);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"new Map<String, String>{'a' => 'b', 'c' => 'd'};"}, {"new Map<String, Integer>{'a' => 22 + 11, 'c' =>  13 + 11};"}, {"SObject a; new Map<Id, SObject>{'00DZ00000003q' => a};"}, {"new Map<Long, Long>{17 => 29};"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }

    @DataProvider
    Object[][] versionData() {
        return new Object[][]{{"new Map<String,  SObject> {};", I18nSupport.getLabel("invalid.sobject.map")}};
    }

    @Test(dataProvider="versionData")
    public void testVersioning(String code, String expectedError) {
        this.tester.setVersion(Version.MIN);
        this.tester.assertFailure(code, expectedError);
    }

    @Test
    public void testInaccessibleKeyType() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(ImmutableList.of("public class Foo { private class InnerFoo { } }", "public class Bar { { Object o = new Map<Foo.InnerFoo, Integer> { null => 23 }; } }"), ImmutableList.of(I18nSupport.getLabel("type.not.visible", "Foo.InnerFoo")));
    }

    @Test
    public void testInaccessibleValueType() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(ImmutableList.of("public class Foo { private class InnerFoo { } }", "public class Bar { { Object o = new Map<Integer, Foo.InnerFoo> { 23 => null }; } }"), ImmutableList.of(I18nSupport.getLabel("type.not.visible", "Foo.InnerFoo")));
    }
}

