/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.collect.ImmutableList;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class NewListLiteralExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"new String[] {true};", I18nSupport.getLabel("invalid.list.initial.expression.type", TypeInfos.STRING, TypeInfos.BOOLEAN)}, {"new List<String> {true};", I18nSupport.getLabel("invalid.list.initial.expression.type", TypeInfos.STRING, TypeInfos.BOOLEAN)}, {"new List<Integer> {1L};", I18nSupport.getLabel("invalid.list.initial.expression.type", TypeInfos.INTEGER, TypeInfos.LONG)}, {"new List<String, String> {};", I18nSupport.getLabel("invalid.list.init")}, {"new List<String> {foo};", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"new List<foo> {};", I18nSupport.getLabel("invalid.unresolved.type", "foo")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"new String[] {'a', 'b'};"}, {"new Integer[] {12, 23};"}, {"new List<String> {'a', null, 'b'};"}, {"new List<Long> {1};"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }

    @DataProvider
    Object[][] versionData() {
        return new Object[][]{{"new SObject[] {};", I18nSupport.getLabel("invalid.sobject.list")}};
    }

    @Test(dataProvider="versionData")
    public void testVersioning(String code, String expectedError) {
        this.tester.setVersion(Version.MIN);
        this.tester.assertFailure(code, expectedError);
    }

    @Test
    public void testInaccessibleType() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(ImmutableList.of("public class Foo { private class InnerFoo { } }", "public class Bar { { Object o = new List<Foo.InnerFoo> { null }; } }"), ImmutableList.of(I18nSupport.getLabel("type.not.visible", "Foo.InnerFoo")));
    }
}

