/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class JavaVariableExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
        this.tester.setTrusted(true);
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"java:foo;", I18nSupport.getLabel("invalid.java.expression")}, {"java:foo.bar;", I18nSupport.getLabel("invalid.java.expression.class.not.found", "foo")}, {"java:java.lang.Integer.FOO;", I18nSupport.getLabel("invalid.java.expression.field.not.found", "FOO", "java.lang.Integer")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] invalidNotTrustedData() {
        return new Object[][]{{"Integer i = java:java.lang.Integer.MAX_VALUE;", I18nSupport.getLabel("illegal.java.expression")}};
    }

    @Test(dataProvider="invalidNotTrustedData")
    public void testInvalidNotTrusted(String code, String expectedError) {
        this.tester.setTrusted(false);
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"Integer i = java:java.lang.Integer.MAX_VALUE;"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }
}

