/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.TestSObjectTypeInfos;
import apex.jorje.semantic.tester.TestVfTypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class InstanceOfExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"List<Account> a; Boolean b = [SELECT Id FROM Account] instanceof Account;", I18nSupport.getLabel("invalid.instanceof.always.false", TestSObjectTypeInfos.ACCOUNT_LIST, TestSObjectTypeInfos.ACCOUNT)}, {"List<Account> a; Boolean b = a instanceof Account;", I18nSupport.getLabel("invalid.instanceof.always.false", TestSObjectTypeInfos.ACCOUNT_LIST, TestSObjectTypeInfos.ACCOUNT)}, {"List<Account> a; Boolean b = a instanceof List<SObject>;", I18nSupport.getLabel("invalid.instanceof.always.true", TestSObjectTypeInfos.ACCOUNT_LIST, ReifiedTypeInfos.SOBJECT_LIST)}, {"List<Account> a; Boolean b = a instanceof SObject;", I18nSupport.getLabel("invalid.instanceof.always.false", TestSObjectTypeInfos.ACCOUNT_LIST, TypeInfos.SOBJECT)}, {"Id id; Boolean b = id instanceof String;", I18nSupport.getLabel("invalid.instanceof.always.true", TypeInfos.ID, TypeInfos.STRING)}, {"Integer i; Boolean b = i instanceof Long;", I18nSupport.getLabel("invalid.instanceof.always.true", TypeInfos.INTEGER, TypeInfos.LONG)}, {"String s; Boolean b = s instanceof Long;", I18nSupport.getLabel("invalid.instanceof.always.false", TypeInfos.STRING, TypeInfos.LONG)}, {"List<Account> aList; Boolean b = aList instanceof List<SObject>;", I18nSupport.getLabel("invalid.instanceof.always.true", TestSObjectTypeInfos.ACCOUNT_LIST, ReifiedTypeInfos.SOBJECT_LIST)}, {"Long l; Boolean b = l instanceof UnresolvedType;", I18nSupport.getLabel("invalid.unresolved.type", "UnresolvedType")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalidAnonymous(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] invalidNamedData() {
        return new Object[][]{{"public class Foo { Component.Apex.Page a; Boolean b = a instanceof String; }", I18nSupport.getLabel("invalid.instanceof.invalid.type", TestVfTypeInfos.APEX_PAGE)}};
    }

    @Test(dataProvider="invalidNamedData")
    public void testInvalid(String code, String expectedError) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"String s; Boolean b = s instanceof Id;"}, {"Long l; Boolean b = l instanceof Integer;"}, {"List<Account> aList; Boolean b = aList instanceof List<Account>;"}, {"List<SObject> aList; Boolean b = aList instanceof List<SObject>;"}, {"List<SObject> aList; Boolean b = aList instanceof List<Account>;"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }

    @Test
    public void testInaccessibleType() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(ImmutableList.of("public class Foo { private class InnerFoo { } }", "public class Bar { { Object o; Boolean b = o instanceof Foo.InnerFoo; } }"), ImmutableList.of(I18nSupport.getLabel("type.not.visible", "Foo.InnerFoo")));
    }

    @Test
    public void testUnassignableInterfaceValid() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess("public class C1 { }", "public interface I1 { }", "public interface I2 { }", "public class Foo {void Method1() {   C1 c1;    I1 i1;    I2 i2;   boolean instOf;    instOf = i1 instanceOf C1;    instOf = c1 instanceOf I1;    instOf = i1 instanceOf I2;} }");
    }
}

