/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class BooleanExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"Boolean b = 1 > 'foobar';", I18nSupport.getLabel("invalid.comparison.types", TypeInfos.INTEGER, TypeInfos.STRING)}, {"Boolean b = 1 >= 'foobar';", I18nSupport.getLabel("invalid.comparison.types", TypeInfos.INTEGER, TypeInfos.STRING)}, {"Boolean b = 1 < 'foobar';", I18nSupport.getLabel("invalid.comparison.types", TypeInfos.INTEGER, TypeInfos.STRING)}, {"Boolean b = 1 >= 'foobar';", I18nSupport.getLabel("invalid.comparison.types", TypeInfos.INTEGER, TypeInfos.STRING)}, {"Boolean b = 1 == 'foobar';", I18nSupport.getLabel("invalid.comparison.types", TypeInfos.INTEGER, TypeInfos.STRING)}, {"Boolean b = 1 != 'foobar';", I18nSupport.getLabel("invalid.comparison.types", TypeInfos.INTEGER, TypeInfos.STRING)}, {"Boolean b = 1 <> 'foobar';", I18nSupport.getLabel("invalid.comparison.types", TypeInfos.INTEGER, TypeInfos.STRING)}, {"Boolean b = 1 === 'foobar';", I18nSupport.getLabel("invalid.comparison.types", TypeInfos.INTEGER, TypeInfos.STRING)}, {"Boolean b = 1 !== 'foobar';", I18nSupport.getLabel("invalid.comparison.types", TypeInfos.INTEGER, TypeInfos.STRING)}, {"Boolean b = 'foobar' > null;", I18nSupport.getLabel("invalid.comparison.types", TypeInfos.STRING, "null")}, {"Boolean b = 'foo' === 'bar';", I18nSupport.getLabel("invalid.exact.equality.type", TypeInfos.STRING)}, {"Boolean b = 1 !== 2.0;", I18nSupport.getLabel("invalid.exact.equality.type", TypeInfos.DECIMAL)}, {"Boolean b = true >= false;", I18nSupport.getLabel("invalid.inequality.type", TypeInfos.BOOLEAN)}, {"Boolean b = true > false;", I18nSupport.getLabel("invalid.inequality.type", TypeInfos.BOOLEAN)}, {"Boolean b = true < false;", I18nSupport.getLabel("invalid.inequality.type", TypeInfos.BOOLEAN)}, {"Boolean b = true <= false;", I18nSupport.getLabel("invalid.inequality.type", TypeInfos.BOOLEAN)}, {"Boolean b = 1 && false;", I18nSupport.getLabel("invalid.logical.type", TypeInfos.BOOLEAN)}, {"Boolean b = 1 && 0;", I18nSupport.getLabel("invalid.logical.type", TypeInfos.BOOLEAN)}, {"Boolean b = 'true' || 'false';", I18nSupport.getLabel("invalid.logical.type", TypeInfos.BOOLEAN)}, {"Boolean b = foo == 1;", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"Boolean b = 1 == foo;", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"NonExistentType g; void method(){ if(g !=  null) {} }", I18nSupport.getLabel("invalid.unresolved.type", "NonExistentType")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"Exception e1, e2; Boolean b = e1 == e2;"}, {"Boolean b = 'foo' == 'bar';"}, {"Boolean b = 'far' != 'bar';"}, {"Boolean b = 1 <> 1.0d;"}, {"Boolean b = 1 > 0;"}, {"Boolean b = 1 >= 0;"}, {"Boolean b = 1 < 0;"}, {"Boolean b = 1 <= 0;"}, {"Object o1, o2; Boolean b = o1 === o2;"}, {"Object o1, o2; Boolean b = o1 !== o2;"}, {"Boolean b = true || false;"}, {"Boolean b = true && false;"}, {"Boolean b = 1 > 0;"}, {"Boolean b = ((1==1) && false) && true;"}, {"Boolean b = ((1==1) || false) || true;"}, {"Boolean b = null == null;"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }
}

