/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.compilation;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.Test;

public class SizeLimitValidationTest
extends ValidationTest {
    @Test
    public void testAnonymousWithinLimits() {
        this.tester.setSizeLimit(50);
        this.tester.setParserType(ParserWrapper.Type.ANONYMOUS);
        this.tester.assertSuccess("public class Foo {private void Bar(){}}");
    }

    @Test
    public void testAnonymousOutsideLimits() {
        this.tester.setSizeLimit(10);
        this.tester.setParserType(ParserWrapper.Type.ANONYMOUS);
        this.tester.assertFailure("public class Foo {private void Bar(){}}", I18nSupport.getLabel("script.too.large", "public cla"));
    }

    @Test
    public void testNamedNoSizeRestriction() {
        this.tester.setSizeLimit(0);
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess("public class Foo {private void Bar(){}}");
    }
}

