/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.compilation;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import java.util.Arrays;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class InvalidCompilationsTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
        this.tester.setParserType(ParserWrapper.Type.NAMED);
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"public enum global {}", new String[]{I18nSupport.getLabel("unexpected.token", "global")}}, {"public interface global {}", new String[]{I18nSupport.getLabel("unexpected.token", "global")}}, {"public class global {}", new String[]{I18nSupport.getLabel("unexpected.token", "global")}}, {"trigger global {}", new String[]{I18nSupport.getLabel("unexpected.token", "global")}}, {"public class foo<global> {}", new String[]{I18nSupport.getLabel("unexpected.token", "global"), I18nSupport.getLabel("type.parameters.not.supported")}}, {"public class foo { class t; }", new String[]{I18nSupport.getLabel("unexpected.syntax", "mismatched input ';' expecting LCURLY")}}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String[] expectedErrors) {
        this.tester.assertFailure(code, Arrays.asList(expectedErrors));
    }
}

