/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.compilation;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfo;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ArgumentTypeInfoTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() {
        this.tester = new ValidationTester();
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.setTrusted(true);
    }

    @Test
    public void testArgumentTypeAsScalarType() {
        this.tester.assertFailure(Arrays.asList("public interface Foo<String> { void bar(String s); }", "public class Bar implements Foo<Integer> { void bar(Integer s) {} }"), "Class, Bar, must implement the method: void Foo<Integer>.bar(String)");
    }

    @Test
    public void testInterfaceExtends() {
        this.tester.assertSuccess("public interface Foo<T> { }", "public interface Bar extends Foo<Integer> {}");
    }

    @Test
    public void testSecondaryTypeArgument() {
        this.tester.assertSuccess("public interface Foo<T,U> {}", "public interface Bar<T> extends Foo<T,Integer> {}", "public class Splat implements Bar<String> {private class InnerSplat implements Bar<Integer> {}}");
    }

    @Test
    public void testTypeInfo() {
        ArgumentTypeInfo type = ArgumentTypeInfo.create("Foo");
        MatcherAssert.assertThat((Object)type.getApexName(), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)type.getBytecodeName(), (Matcher)Matchers.is((Object)TypeInfos.OBJECT.getBytecodeName()));
        MatcherAssert.assertThat((Object)((Object)type.getBasicType()), (Matcher)Matchers.is((Object)((Object)BasicType.OBJECT)));
    }
}

