/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.tester.matchers;

import com.google.common.collect.Multimap;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.IsEqual;

public class IsMultiMapContaining<K, V>
extends TypeSafeDiagnosingMatcher<Multimap<? extends K, ? extends V>> {
    private final IsMapContaining matcher;

    private IsMultiMapContaining(Matcher<? extends K> keyMatcher, Matcher<Iterable<? extends V>> valueMatcher) {
        this.matcher = new IsMapContaining(keyMatcher, valueMatcher);
    }

    @SafeVarargs
    public static <K, V> IsMultiMapContaining<K, V> hasMultiEntry(K key, V ... values) {
        return new IsMultiMapContaining<K, V>(IsEqual.equalTo(key), Matchers.containsInAnyOrder((Object[])values));
    }

    protected boolean matchesSafely(Multimap<? extends K, ? extends V> item, Description mismatchDescription) {
        mismatchDescription.appendText("multimap with ");
        this.matcher.describeMismatchSafely(item.asMap(), mismatchDescription);
        return this.matcher.matchesSafely(item.asMap());
    }

    public void describeTo(Description description) {
        description.appendText("multimap with ");
        this.matcher.describeTo(description);
    }
}

