/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.tester.matchers;

import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.modifier.ModifierOrAnnotation;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class HasAnnotationParameter
extends TypeSafeDiagnosingMatcher<ModifierOrAnnotation> {
    private final String name;
    private final Matcher<String> value;

    private HasAnnotationParameter(String name, Matcher<String> value) {
        this.name = name;
        this.value = value;
    }

    public static Matcher<ModifierOrAnnotation> annotationTrue(String name) {
        return new HasAnnotationParameter(name, (Matcher<String>)Matchers.equalToIgnoringCase((String)"true"));
    }

    public static Matcher<ModifierOrAnnotation> annotationFalse(String name) {
        return new HasAnnotationParameter(name, (Matcher<String>)Matchers.equalToIgnoringCase((String)"false"));
    }

    public static Matcher<ModifierOrAnnotation> annotationValue(String name, String value) {
        return new HasAnnotationParameter(name, (Matcher<String>)Matchers.equalToIgnoringCase((String)value));
    }

    public void describeTo(Description description) {
        description.appendValue((Object)this.name).appendText("->");
        this.value.describeTo(description);
    }

    protected boolean matchesSafely(ModifierOrAnnotation annotation, Description description) {
        AnnotationParameter parameter = annotation.getParameter(this.name);
        if (parameter == null) {
            description.appendText("annotation parameter was not found");
            return false;
        }
        String actual = parameter.getValue().match(AnnotationParameter.GET_VALUE);
        this.value.describeMismatch((Object)actual, description);
        return this.value.matches((Object)actual);
    }
}

