/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.tester;

import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.compiler.ApexCompiler;
import apex.jorje.semantic.compiler.CompilationInput;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.compiler.sfdc.QueryValidator;
import apex.jorje.semantic.tester.TestAccessEvaluator;
import apex.jorje.semantic.tester.TestQueryValidators;
import apex.jorje.semantic.tester.TestSymbolProvider;
import apex.jorje.semantic.tester.matchers.ErrorMatchers;
import apex.jorje.semantic.tester.matchers.IterableMatchers;
import apex.jorje.services.Version;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class ValidationTester {
    private Version version;
    private boolean isTrusted;
    private boolean isFileBased;
    private String allPackageId;
    private ParserWrapper.Type parserType;
    private TestSymbolProvider symbolProvider;
    private TestAccessEvaluator accessEvaluator;
    private QueryValidator queryValidator;
    private Namespace namespace;
    private AstVisitor<AdditionalPassScope> additionalPass;
    private int sizeLimit;

    public ValidationTester() {
        this.clear();
    }

    public ValidationTester setParserType(ParserWrapper.Type parserType) {
        this.parserType = parserType;
        return this;
    }

    public ValidationTester setVersion(Version version) {
        this.version = version;
        return this;
    }

    public ValidationTester setTrusted(boolean isTrusted) {
        this.isTrusted = isTrusted;
        return this;
    }

    public ValidationTester setFileBased(boolean isFileBased) {
        this.isFileBased = isFileBased;
        return this;
    }

    public ValidationTester setAllPackageId(String allPackageId) {
        this.allPackageId = allPackageId;
        return this;
    }

    public ValidationTester setQueryValidator(QueryValidator queryValidator) {
        this.queryValidator = queryValidator;
        return this;
    }

    public ValidationTester setSizeLimit(int sizeLimit) {
        this.sizeLimit = sizeLimit;
        return this;
    }

    public ValidationTester setNamespace(Namespace namespace) {
        this.namespace = namespace;
        return this;
    }

    public void setAdditionalPass(AstVisitor<AdditionalPassScope> additionalPass) {
        this.additionalPass = additionalPass;
    }

    public void addTestLabelField(String namespace, String name) {
        this.symbolProvider.addLabelField(namespace, name);
    }

    public void addTestPageReference(String name, String value) {
        this.symbolProvider.addPageReference(name, value);
    }

    public ValidationTester clear() {
        this.version = Version.CURRENT;
        this.isTrusted = false;
        this.isFileBased = false;
        this.allPackageId = null;
        this.parserType = ParserWrapper.Type.ANONYMOUS;
        this.symbolProvider = new TestSymbolProvider();
        this.accessEvaluator = new TestAccessEvaluator();
        this.queryValidator = new TestQueryValidators.Noop();
        this.namespace = Namespaces.EMPTY;
        this.sizeLimit = Integer.MAX_VALUE;
        return this;
    }

    public void assertFailure(String code, String ... expectedErrors) {
        this.assertFailure(code, Arrays.asList(expectedErrors));
    }

    public void assertFailure(String code, List<String> expectedErrors) {
        this.assertFailure(Collections.singletonList(code), expectedErrors);
    }

    public void assertFailure(SourceFile sourceFile, String ... expectedErrors) {
        this.assertFailure(sourceFile, Arrays.asList(expectedErrors));
    }

    public void assertFailure(SourceFile sourceFile, List<String> expectedErrors) {
        this.assertFailures(Collections.singletonList(sourceFile), expectedErrors);
    }

    public void assertFailure(String[] codes, String ... expectedErrors) {
        this.assertFailure(Arrays.asList(codes), Arrays.asList(expectedErrors));
    }

    public void assertFailure(List<String> codes, String ... expectedErrors) {
        this.assertFailure(codes, Arrays.asList(expectedErrors));
    }

    public void assertFailure(List<String> codes, List<String> expectedErrors) {
        this.assertFailures(this.createSources(codes), expectedErrors);
    }

    public void assertFailures(List<SourceFile> codes, String ... expectedErrors) {
        this.assertFailures(codes, Arrays.asList(expectedErrors));
    }

    public void assertFailures(List<SourceFile> codes, List<String> expectedErrors) {
        List<CompilationException> actualErrors = this.compileFailure(this.parserType, codes);
        MatcherAssert.assertThat(actualErrors, ErrorMatchers.containsErrors(expectedErrors));
    }

    public void assertFailures(Multimap<Namespace, String> namespacedSources, String ... expectedErrors) {
        this.assertFailures(this.createNamespacedSources(namespacedSources), Arrays.asList(expectedErrors));
    }

    public void assertLocFailure(String code, CompilationException ... expectedErrors) {
        this.assertLocFailure(code, Arrays.asList(expectedErrors));
    }

    public void assertLocFailure(String code, Iterable<CompilationException> expectedErrors) {
        List<CompilationException> actualErrors = this.compileFailure(this.parserType, this.createSource(code));
        MatcherAssert.assertThat(actualErrors, IterableMatchers.contains(expectedErrors));
    }

    public void assertSuccess(String ... code) {
        this.assertSuccess(Arrays.asList(code));
    }

    public void assertSuccess(List<String> codes) {
        this.assertSuccesses(this.createSources(codes));
    }

    public void assertSuccess(SourceFile ... sourceFile) {
        this.assertSuccesses(Arrays.asList(sourceFile));
    }

    public void assertSuccesses(List<SourceFile> sourceFile) {
        List<CompilationException> actualErrors = this.compileFailure(this.parserType, sourceFile);
        MatcherAssert.assertThat(actualErrors, (Matcher)Matchers.empty());
    }

    public void assertSuccesses(Multimap<Namespace, String> namespacedSources) {
        this.assertSuccesses(this.createNamespacedSources(namespacedSources));
    }

    public List<CompilationException> compileFailure(ParserWrapper.Type type, SourceFile ... sources) {
        return this.compileFailure(type, Arrays.asList(sources));
    }

    public List<CompilationException> compileFailure(ParserWrapper.Type type, Collection<SourceFile> sources) {
        ApexCompiler compiler = this.buildCompiler(type, sources);
        compiler.compile();
        return compiler.getErrors();
    }

    public ApexCompiler buildCompiler(ParserWrapper.Type type, Collection<SourceFile> sources) {
        CompilationInput input = new CompilationInput(sources, this.symbolProvider, this.accessEvaluator, this.queryValidator, this.additionalPass);
        return ApexCompiler.builder().setInput(input).setParserType(type).build();
    }

    public SourceFile createSource(String code) {
        return SourceFile.builder().setBody(code).setVersion(this.version).setTrusted(this.isTrusted).setFileBased(this.isFileBased).setNamespace(this.namespace).setAllPackageId(this.allPackageId).setSizeLimit(this.sizeLimit).build();
    }

    public List<SourceFile> createSources(List<String> codes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String code : codes) {
            builder.add(this.createSource(code));
        }
        return builder.build();
    }

    public List<SourceFile> createNamespacedSources(Multimap<Namespace, String> namespacedCodes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<Namespace, String> entry : namespacedCodes.entries()) {
            this.setNamespace(entry.getKey());
            builder.add(this.createSource(entry.getValue()));
        }
        return builder.build();
    }

    public TestAccessEvaluator getAccessEvaluator() {
        return this.accessEvaluator;
    }

    public TestSymbolProvider getSymbolProvider() {
        return this.symbolProvider;
    }
}

