/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.tester;

import apex.jorje.semantic.common.iterable.CaseInsensitiveMap;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.sfdc.SymbolProvider;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoTables;
import apex.jorje.semantic.symbol.type.common.DynamicTypeNameFactory;
import apex.jorje.semantic.tester.TestFlowInterviewTypeInfos;
import apex.jorje.semantic.tester.TestSObjectTypeInfos;
import apex.jorje.semantic.tester.TestStandardTypeInfos;
import apex.jorje.semantic.tester.TestVfTypeInfos;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.HashSet;
import java.util.Map;

public class TestSymbolProvider
implements SymbolProvider {
    private static final Map<String, TypeInfo> BUILT_IN_TYPES = TypeInfoTables.bytecodeNameMap(TestStandardTypeInfos.class, TypeInfo.class);
    private static final Map<String, TypeInfo> FLOW_INTERVIEW_TYPES = TypeInfoTables.bytecodeNameMap(TestFlowInterviewTypeInfos.class, TypeInfo.class);
    private static final Map<String, TypeInfo> SOBJECT_TYPES = CaseInsensitiveMap.builder().put(TestSObjectTypeInfos.ACCOUNT.getApexName(), TestSObjectTypeInfos.ACCOUNT).put(TestSObjectTypeInfos.AGGREGATE_RESULT.getApexName(), TestSObjectTypeInfos.AGGREGATE_RESULT).put(TestSObjectTypeInfos.USER.getApexName(), TestSObjectTypeInfos.USER).put(TestSObjectTypeInfos.BUSINESS_HOURS.getApexName(), TestSObjectTypeInfos.BUSINESS_HOURS).put(TestSObjectTypeInfos.USER_PREFERENCE.getApexName(), TestSObjectTypeInfos.USER_PREFERENCE).put(TestSObjectTypeInfos.USER_PROFILE_FEED.getApexName(), TestSObjectTypeInfos.USER_PROFILE_FEED).put(TestSObjectTypeInfos.OPPORTUNITY.getApexName(), TestSObjectTypeInfos.OPPORTUNITY).put(TestSObjectTypeInfos.CASE.getApexName(), TestSObjectTypeInfos.CASE).put(TestSObjectTypeInfos.CONTACT.getApexName(), TestSObjectTypeInfos.CONTACT).put(TestSObjectTypeInfos.KNOWLEDGE_ARTICLE_VERSION.getApexName(), TestSObjectTypeInfos.KNOWLEDGE_ARTICLE_VERSION).put(TestSObjectTypeInfos.LEAD.getApexName(), TestSObjectTypeInfos.LEAD).put(TestSObjectTypeInfos.LIST_CUSTOM_SETTING.getApexName(), TestSObjectTypeInfos.LIST_CUSTOM_SETTING).put(TestSObjectTypeInfos.MAP_CUSTOM_SETTING.getApexName(), TestSObjectTypeInfos.MAP_CUSTOM_SETTING).put(TestSObjectTypeInfos.NAMESPACED_MAP_SETTING.getApexNameSansNamespace(), TestSObjectTypeInfos.NAMESPACED_MAP_SETTING).put(TestSObjectTypeInfos.SOBJECT_WITH_CUSTOM_DATA_TYPE_FIELD.getApexName(), TestSObjectTypeInfos.SOBJECT_WITH_CUSTOM_DATA_TYPE_FIELD).build();
    private static final Map<String, TypeInfo> VF_COMPONENT_TYPES = TypeInfoTables.bytecodeNameMap(TestVfTypeInfos.class, TypeInfo.class);
    private final Map<String, AdditionalFile> additionalFiles = new CaseInsensitiveMap<AdditionalFile>();
    private final Map<String, TypeInfo> additionalTypes = new CaseInsensitiveMap<TypeInfo>();
    private final SetMultimap<String, String> labels;
    private final Map<String, String> pageReferences;

    public TestSymbolProvider() {
        this.additionalTypes.putAll(BUILT_IN_TYPES);
        this.labels = Multimaps.newSetMultimap(new CaseInsensitiveMap(), HashSet::new);
        this.pageReferences = new CaseInsensitiveMap<String>();
    }

    @Override
    public void reportParsed(CodeUnit codeUnit) {
    }

    @Override
    public TypeInfo find(SymbolResolver symbols, TypeInfo referencingType, String fullName) {
        AdditionalFile file = this.additionalFiles.get(fullName);
        return file != null ? file.getType(symbols, fullName) : this.additionalTypes.get(fullName);
    }

    @Override
    public TypeInfo getVfComponentType(SymbolResolver symbols, TypeInfo referencingType, Namespace namespace, String name) {
        String fullName = DynamicTypeNameFactory.createVfComponent(namespace, name);
        return VF_COMPONENT_TYPES.get(fullName);
    }

    @Override
    public TypeInfo getFlowInterviewType(SymbolResolver symbols, TypeInfo referencingType, Namespace namespace, String name) {
        String fullName = DynamicTypeNameFactory.createFlowInterview(namespace, name);
        return FLOW_INTERVIEW_TYPES.get(fullName);
    }

    @Override
    public TypeInfo getSObjectType(TypeInfo referencingType, String name) {
        return SOBJECT_TYPES.get(name);
    }

    @Override
    public String getPageReference(TypeInfo referencingType, String name) {
        return this.pageReferences.get(name);
    }

    @Override
    public boolean hasLabelField(TypeInfo referencingType, Namespace namespace, String name) {
        return this.labels.get(namespace.toString()).contains(name);
    }

    public void addLabelField(String namespace, String name) {
        this.labels.put(namespace, name);
    }

    public void addPageReference(String name, String value) {
        this.pageReferences.put(name, value);
    }

    public TestSymbolProvider addAdditionalFiles(SourceFile ... additionalFiles) {
        for (SourceFile sourceFile : additionalFiles) {
            this.additionalFiles.put(sourceFile.getKnownName(), new AdditionalFile(sourceFile));
        }
        return this;
    }

    public TestSymbolProvider addAdditionalTypes(TypeInfo ... types) {
        for (TypeInfo type : types) {
            this.additionalTypes.put(type.getBytecodeName(), type);
        }
        return this;
    }

    private static class AdditionalFile {
        private final SourceFile sourceFile;
        private TypeInfo type;

        public AdditionalFile(SourceFile sourceFile) {
            this.sourceFile = sourceFile;
        }

        public TypeInfo getType(SymbolResolver symbols, String fullNameLower) {
            return this.type == null ? (this.type = symbols.getCompilerService().attachAdditionalSource(symbols, this.sourceFile, fullNameLower)) : this.type;
        }
    }
}

