/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility;

import apex.jorje.semantic.compiler.ApexCompiler;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.semantic.tester.matchers.ErrorMatchers;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class SfdcOnlySelectedVisibilityTest
extends ValidationTest {
    private List<CompilationException> compileForSfdcTests(List<String> trustedSourcesInSystemNamespace, List<String> untrustedSourcesInEmptyNamespace) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String trustedSource : trustedSourcesInSystemNamespace) {
            this.tester.setTrusted(true);
            this.tester.setNamespace(Namespaces.SYSTEM);
            builder.add(this.tester.createSource(trustedSource));
        }
        for (String untrustedSource : untrustedSourcesInEmptyNamespace) {
            this.tester.setTrusted(false);
            this.tester.setNamespace(Namespaces.EMPTY);
            builder.add(this.tester.createSource(untrustedSource));
        }
        ApexCompiler compiler = this.tester.buildCompiler(ParserWrapper.Type.NAMED, builder.build());
        compiler.compile();
        return compiler.getErrors();
    }

    private void assertSfdcOnlySuccess(List<String> trustedSourcesInSystemNamespace, List<String> untrustedSourcesInEmptyNamespace) {
        List<CompilationException> actualErrors = this.compileForSfdcTests(trustedSourcesInSystemNamespace, untrustedSourcesInEmptyNamespace);
        MatcherAssert.assertThat(actualErrors, (Matcher)Matchers.empty());
    }

    private void assertSfdcOnlyFailure(List<String> trustedSourcesInSystemNamespace, List<String> untrustedSourcesInEmptyNamespace, List<String> expectedErrorMessages) {
        List<CompilationException> actualErrors = this.compileForSfdcTests(trustedSourcesInSystemNamespace, untrustedSourcesInEmptyNamespace);
        MatcherAssert.assertThat(actualErrors, ErrorMatchers.containsErrors(expectedErrorMessages));
    }

    @Test
    public void testVisibleTypePropertyDeclaration() {
        this.assertSfdcOnlySuccess(ImmutableList.of("@SfdcOnly global class Foo { }"), ImmutableList.of("public class Bar { public Foo someProperty { get; set; } }"));
    }

    @Test
    public void testVisibleTypeExtended() {
        this.assertSfdcOnlySuccess(ImmutableList.of("@SfdcOnly global virtual class Foo { }"), ImmutableList.of("public class Bar extends Foo { }"));
    }

    @Test
    public void testVisibleTypeCast() {
        this.assertSfdcOnlySuccess(ImmutableList.of("@SfdcOnly global class Foo { }"), ImmutableList.of("public class Bar { { Object a; Object b = (Foo)a; } }"));
    }

    @Test
    public void testVisibleTypeInstanceOf() {
        this.assertSfdcOnlySuccess(ImmutableList.of("@SfdcOnly global class Foo { }"), ImmutableList.of("public class Bar { { Object a; Boolean b = a instanceof Foo; } }"));
    }

    @Test
    public void testVisibleTypeClass() {
        this.assertSfdcOnlySuccess(ImmutableList.of("@SfdcOnly global class Foo { }"), ImmutableList.of("public class Bar { { Object o = Foo.class; } }"));
    }

    @Test
    public void testVisibleTypeGenericArgument() {
        this.assertSfdcOnlySuccess(ImmutableList.of("@SfdcOnly global class Foo { }"), ImmutableList.of("public class Bar { { List<Foo> o; } }"));
    }

    @Test
    public void testVisibleTypeReturnTypeInMethodCall() {
        this.assertSfdcOnlySuccess(ImmutableList.of("@SfdcOnly global class Foo { }", "global class Bar { global Foo method() { return null; } }"), ImmutableList.of("public class Baz { { Bar b; b.method(); } }"));
    }

    @Test
    public void testVisibleTypeParameterInMethodCall() {
        this.assertSfdcOnlySuccess(ImmutableList.of("@SfdcOnly global class Foo { }", "global class Bar { global void method(Foo f) { } }"), ImmutableList.of("public class Baz { { Object o; Bar b; b.method((Foo)o); } }"));
    }

    @Test
    public void testVisibleTypeInNewMethodReturnType() {
        this.assertSfdcOnlySuccess(ImmutableList.of("@SfdcOnly global class Foo { }"), ImmutableList.of("public class Bar { Foo m() { return null; } }"));
    }

    @Test
    public void testVisibleTypeInNewMethodParameter() {
        this.assertSfdcOnlySuccess(ImmutableList.of("@SfdcOnly global class Foo { }"), ImmutableList.of("public class Bar { void m(Foo f) { } }"));
    }

    @Test
    public void testVisibleTypeOnCallingStaticMethod() {
        this.assertSfdcOnlySuccess(ImmutableList.of("@SfdcOnly global class Foo { @SfdcOnly(value='false') global static void method() { } }"), ImmutableList.of("public class Bar { { Foo.method(); } }"));
    }

    @Test
    void testNotVisibleTypeFieldDeclaration() {
        this.assertSfdcOnlyFailure(ImmutableList.of("@SfdcOnly global class Foo { }"), ImmutableList.of("global class Bar { Foo f; }"), ImmutableList.of(I18nSupport.getLabel("type.not.visible", "System.Foo")));
    }

    @Test
    void testNotVisibleTypeLocalDeclaration() {
        this.assertSfdcOnlyFailure(ImmutableList.of("@SfdcOnly global class Foo { }"), ImmutableList.of("global class Bar { { Foo f; } }"), ImmutableList.of(I18nSupport.getLabel("type.not.visible", "System.Foo")));
    }

    @Test
    void testNotVisibleTypeNewObjectExpression() {
        this.assertSfdcOnlyFailure(ImmutableList.of("@SfdcOnly global class Foo { }"), ImmutableList.of("global class Bar { { Object o = new Foo(); } }"), ImmutableList.of(I18nSupport.getLabel("method.not.visible", "void System.Foo.<init>()")));
    }

    @Test
    void testNotVisibleTypeNewObjectExpressionVersion() {
        this.tester.setVersion(Version.V184);
        this.assertSfdcOnlySuccess(ImmutableList.of("@SfdcOnly global class Foo { }"), ImmutableList.of("global class Bar { { Object o = new Foo(); } }"));
    }

    @Test
    void testVisibleInnerClassInSfdcOnlyOuterClassInExplicitNamespace() {
        this.tester.getAccessEvaluator().setHasInternalSfdc(true);
        this.assertSfdcOnlySuccess(ImmutableList.of("@SfdcOnly global class Foo { global class Bar { } }"), ImmutableList.of("public class Baz { { System.Foo.Bar x; } }"));
    }

    @Test
    public void testVisibleMethodOnOverride() {
        this.assertSfdcOnlySuccess(ImmutableList.of("global virtual class Foo { @SfdcOnly global virtual void method() { } }"), ImmutableList.of("public class Bar extends Foo { public override void method() { } }"));
    }

    @Test
    void testNotVisibleMethodCall() {
        this.assertSfdcOnlyFailure(ImmutableList.of("global class Foo { @SfdcOnly global void method() { } }"), ImmutableList.of("global class Bar { { Foo f; f.method(); } }"), ImmutableList.of(I18nSupport.getLabel("method.not.visible", "void System.Foo.method()")));
    }
}

