/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility;

import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.semantic.tester.TestConstants;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableListMultimap;
import org.testng.annotations.Test;

public class ReferenceExpressionTest
extends ValidationTest {
    @Test
    public void testInaccessibleReferenceTypeForVariable() {
        this.tester.assertFailure(new String[]{"public class Foo { private class InnerFoo { public String s; } }", "public class Bar { String s = Foo.InnerFoo.s; }"}, I18nSupport.getLabel("type.not.visible", "Foo.InnerFoo"));
    }

    @Test
    public void testInaccessibleNestedReferenceTypeForVariable() {
        this.tester.assertFailure(new String[]{"public class Foo { public String s; private class InnerFoo { public Foo f; } }", "public class Bar { String s = Foo.InnerFoo.f.s; }"}, I18nSupport.getLabel("variable.does.not.exist", "Foo.InnerFoo.f"));
    }

    @Test
    public void testInaccessibleReferenceTypeForStaticVariable() {
        this.tester.assertFailures(((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)ImmutableListMultimap.builder().put(TestConstants.NAMESPACE_A, "public class Bar { public static Integer i; }")).put(TestConstants.NAMESPACE_B, "public class Foo { public Integer i = NamespaceA.Bar.i; }")).build(), I18nSupport.getLabel("type.not.visible", "NamespaceA.Bar"));
    }

    @Test
    public void testInaccessibleReferenceTypeForMethod() {
        this.tester.assertFailure(new String[]{"public class Foo { private class InnerFoo { public void foo() {} } }", "public class Bar { String s = Foo.InnerFoo.foo(); }"}, I18nSupport.getLabel("type.not.visible", "Foo.InnerFoo"));
    }

    @Test
    public void testInaccessibleFieldReferenceForField() {
        this.tester.assertFailure(new String[]{"public class Foo { private Foo f; public String s; }", "public class Bar { Foo myFoo; String s = myFoo.f.s; }"}, I18nSupport.getLabel("variable.not.visible", "Foo.f"));
    }

    @Test
    public void testInaccessiblePropertyReferenceFromField() {
        this.tester.assertFailure(new String[]{"public class SomeClass { private static SomeClass sc1; public Object getObject { get; set; }  }", "public class TestClass { Object o = SomeClass.sc1.getObject; }"}, I18nSupport.getLabel("variable.not.visible", "SomeClass.sc1"));
    }

    @Test
    public void testInaccessiblePropertyReferenceFromField2() {
        this.tester.assertFailure(new String[]{"public class SomeClass { public static SomeClass sc1; private Object getObject { get; set; }  }", "public class TestClass { Object o = SomeClass.sc1.getObject; }"}, I18nSupport.getLabel("variable.not.visible", "SomeClass.getObject"));
    }
}

