/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility;

import apex.jorje.data.Loc;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.StructuredVersion;
import apex.jorje.semantic.compiler.StructuredVersionRange;
import apex.jorje.semantic.symbol.visibility.PackagingVersionVisibility;
import com.google.common.collect.ImmutableMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class PackagingVersionVisibilityTest {
    private static final StructuredVersion VERSION_1 = new StructuredVersion(1, 0);
    private static final StructuredVersion VERSION_2 = new StructuredVersion(2, 0);
    private static final StructuredVersion VERSION_3 = new StructuredVersion(3, 0);
    private static final StructuredVersion VERSION_4 = new StructuredVersion(4, 0);
    private static final StructuredVersion VERSION_5 = new StructuredVersion(5, 0);
    private static final StructuredVersionRange MIN_2_MAX_4 = new StructuredVersionRange(VERSION_2, VERSION_4);
    private static final Namespace SOME_NAMESPACE = Namespaces.create("SomeNamespace");
    private static final Loc SOME_LOC = Loc._RealLoc(0, 0, 42, 24);

    @Test
    public void classReference() {
        MatcherAssert.assertThat((Object)PackagingVersionVisibility.isPackagingVersionVisible(ImmutableMap.of(SOME_NAMESPACE, VERSION_3), ImmutableMap.of(PackagingVersionVisibility.toPosition(SOME_LOC), MIN_2_MAX_4), SOME_NAMESPACE, SOME_LOC), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void classReferenceOutOfRange() {
        MatcherAssert.assertThat((Object)PackagingVersionVisibility.isPackagingVersionVisible(ImmutableMap.of(SOME_NAMESPACE, VERSION_1), ImmutableMap.of(PackagingVersionVisibility.toPosition(SOME_LOC), MIN_2_MAX_4), SOME_NAMESPACE, SOME_LOC), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void noImportSucceeds() {
        MatcherAssert.assertThat((Object)PackagingVersionVisibility.isPackagingVersionVisible(ImmutableMap.of(), ImmutableMap.of(PackagingVersionVisibility.toPosition(SOME_LOC), MIN_2_MAX_4), SOME_NAMESPACE, SOME_LOC), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void noExportedVersionSucceeds() {
        MatcherAssert.assertThat((Object)PackagingVersionVisibility.isPackagingVersionVisible(ImmutableMap.of(SOME_NAMESPACE, VERSION_3), ImmutableMap.of(), SOME_NAMESPACE, SOME_LOC), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void versionLessThanMin() {
        MatcherAssert.assertThat((Object)PackagingVersionVisibility.isVersionInRange(VERSION_1, MIN_2_MAX_4), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void versionEqualToMin() {
        MatcherAssert.assertThat((Object)PackagingVersionVisibility.isVersionInRange(VERSION_2, MIN_2_MAX_4), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void versionBetweenMinMax() {
        MatcherAssert.assertThat((Object)PackagingVersionVisibility.isVersionInRange(VERSION_3, MIN_2_MAX_4), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void versionEqualToMax() {
        MatcherAssert.assertThat((Object)PackagingVersionVisibility.isVersionInRange(VERSION_4, MIN_2_MAX_4), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void versionGreaterThanMax() {
        MatcherAssert.assertThat((Object)PackagingVersionVisibility.isVersionInRange(VERSION_5, MIN_2_MAX_4), (Matcher)Matchers.is((Object)false));
    }
}

