/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility;

import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.Position;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.StructuredVersion;
import apex.jorje.semantic.compiler.StructuredVersionRange;
import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class PackagingVersionVisibilityEndToEndTest {
    private static final Namespace NAMESPACE_MANAGED_PACKAGE = Namespaces.create("SomeManagedPackage");
    private static final StructuredVersion VERSION_1 = new StructuredVersion(1, 0);
    private static final StructuredVersion VERSION_2 = new StructuredVersion(2, 0);
    private ValidationTester tester;

    @BeforeClass
    public void testSetup() {
        this.tester = new ValidationTester();
        this.tester.setParserType(ParserWrapper.Type.NAMED);
    }

    @Test
    public void testTypeVisibility() {
        SourceFile exportedSourceFile = PackagingVersionVisibilityEndToEndTest.createExportingSourceFile("global class TypeV2 { }", "TypeV2");
        SourceFile importingSourceFile = PackagingVersionVisibilityEndToEndTest.createImportingSourceFile("global class Bar { " + NAMESPACE_MANAGED_PACKAGE.toString() + ".TypeV2 x; }");
        this.tester.assertFailures(Lists.newArrayList(exportedSourceFile, importingSourceFile), I18nSupport.getLabel("type.not.visible", NAMESPACE_MANAGED_PACKAGE.toString() + ".TypeV2"));
    }

    @Test
    public void testMemberVisibility() {
        SourceFile exportedSourceFile = PackagingVersionVisibilityEndToEndTest.createExportingSourceFile("global class SomeType { global static void SomeMethod() { } }", "SomeMethod");
        SourceFile importingSourceFile = PackagingVersionVisibilityEndToEndTest.createImportingSourceFile("global class Bar { { " + NAMESPACE_MANAGED_PACKAGE.toString() + ".SomeType.SomeMethod(); } }");
        this.tester.assertFailures(Lists.newArrayList(exportedSourceFile, importingSourceFile), I18nSupport.getLabel("method.not.visible", "void " + NAMESPACE_MANAGED_PACKAGE.toString() + ".SomeType.SomeMethod()"));
    }

    private static SourceFile createImportingSourceFile(String source) {
        return SourceFile.builder().setBody(source).setReferencedPackageVersions(ImmutableMap.of(NAMESPACE_MANAGED_PACKAGE, VERSION_1)).build();
    }

    private static SourceFile createExportingSourceFile(String source, String exportedIdentifier) {
        return SourceFile.builder().setNamespace(NAMESPACE_MANAGED_PACKAGE).setBody(source).setExportedPackageVersions(ImmutableMap.of(PackagingVersionVisibilityEndToEndTest.getPositionOfToken(source, exportedIdentifier), new StructuredVersionRange(VERSION_2, StructuredVersion.DEFAULT_MAX_VERSION))).build();
    }

    private static Position getPositionOfToken(String source, String token) {
        int line = 1;
        int column = 1;
        int index = source.indexOf(token);
        Preconditions.checkArgument(index >= 0, "'" + token + "' doesn't exist in source");
        for (int i = 0; i < index; ++i) {
            if (source.charAt(i) == '\n') {
                ++line;
                column = 1;
                continue;
            }
            ++column;
        }
        return new Position(line, column);
    }
}

