/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility;

import apex.jorje.data.Loc;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Position;
import apex.jorje.semantic.compiler.StructuredVersion;
import apex.jorje.semantic.compiler.StructuredVersionRange;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.Location;
import java.util.Map;

public class PackagingVersionVisibility {
    public static boolean isPackagingVersionVisible(TypeInfo referencingType, TypeInfo targetDefiningType, Loc targetLoc) {
        if (!referencingType.getCodeUnitDetails().isApexSourceBased() || !targetDefiningType.getCodeUnitDetails().isApexSourceBased() || !Location.isReal(targetLoc) || referencingType.getNamespace().equals(targetDefiningType.getNamespace())) {
            return true;
        }
        return PackagingVersionVisibility.isPackagingVersionVisible(referencingType.getCodeUnitDetails().getSource().getReferencedPackageVersions(), targetDefiningType.getCodeUnitDetails().getSource().getExportedPackageVersions(), targetDefiningType.getNamespace(), targetLoc);
    }

    static boolean isPackagingVersionVisible(Map<Namespace, StructuredVersion> referencedPackagesMap, Map<Position, StructuredVersionRange> exportedVersionsMap, Namespace targetNamespace, Loc targetLoc) {
        StructuredVersion importedVersion = referencedPackagesMap.get(targetNamespace);
        if (importedVersion == null) {
            return true;
        }
        StructuredVersionRange exportedStructuredVersionRange = exportedVersionsMap.get(PackagingVersionVisibility.toPosition(targetLoc));
        return exportedStructuredVersionRange == null || PackagingVersionVisibility.isVersionInRange(importedVersion, exportedStructuredVersionRange);
    }

    static boolean isVersionInRange(StructuredVersion importedVersion, StructuredVersionRange exportedRange) {
        return importedVersion.compareTo(exportedRange.getMinVersion()) >= 0 && importedVersion.compareTo(exportedRange.getMaxVersion()) < 0;
    }

    static Position toPosition(Loc loc) {
        return loc.match(new Loc.MatchBlock<Position>(){

            @Override
            public Position _case(Loc.RealLoc x) {
                return new Position(x.line, x.column);
            }

            @Override
            public Position _case(Loc.SyntheticLoc x) {
                throw new UnexpectedCodePathException("Referenced managed package element should have a real source-based location");
            }
        });
    }
}

