/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility;

import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MethodCallVisibility {
    public static List<String> calculate(TypeInfo referencingType, AccessEvaluator accessEvaluator, boolean isReferencedFromTestMethod, MethodInfo method) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        boolean isSfdcOnlyVisible = Visibility.isMemberSfdcOnlyVisible(accessEvaluator, referencingType, method.getDefiningType(), method.getModifiers(), method.getJavaSfdcOnlyAnnotation());
        if (!isSfdcOnlyVisible && method.isConstructor() && method.getDefiningType().getModifiers().has(AnnotationTypeInfos.SFDC_ONLY) && method.getGenerated() != Generated.USER && referencingType.getCodeUnitDetails().getVersion().isLessThan(Version.V186)) {
            return Collections.emptyList();
        }
        if (!(isSfdcOnlyVisible && Visibility.isMethodPrivateApiVisible(accessEvaluator, method.getModifiers(), method.getDefiningType().getModifiers()) && Visibility.isMethodAllowCertifiedApexVisible(accessEvaluator, method.getModifiers(), method.getDefiningType().getModifiers()) && Visibility.isMemberVisible(referencingType, method, isReferencedFromTestMethod))) {
            errorMessages.add(I18nSupport.getLabel("method.not.visible", method));
            return errorMessages;
        }
        if (!Visibility.isTypeVisibleInImplicitReference(accessEvaluator, referencingType, method.getReturnType(), isReferencedFromTestMethod)) {
            errorMessages.add(I18nSupport.getLabel("method.return.type.not.visible", method.getReturnType(), method.getSignature()));
        }
        for (TypeInfo typeToCheck : method.getParameterTypes()) {
            if (Visibility.isTypeVisible(accessEvaluator, referencingType, typeToCheck, isReferencedFromTestMethod)) continue;
            errorMessages.add(I18nSupport.getLabel("method.parameter.type.not.visible", typeToCheck, method.getSignature()));
        }
        return errorMessages;
    }
}

