/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility;

import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.Version;

public class LegacyVisibility {
    public static boolean isLegacyVisibleForPropertyWrites(TypeInfo accessingType, Variable variable) {
        assert (variable.getMemberType() == Member.Type.PROPERTY);
        ModifierGroup setterModifiers = variable.accept(new Visibility.ModifiersFinder(Visibility.CheckType.CALLER_WRITE), null);
        if (variable.getDefiningType().getCodeUnitDetails().getVersion().isLessThanOrEqual(Version.V154) && Visibility.AccessType.HIDDEN == Visibility.AccessType.get(setterModifiers, variable.getMemberType() == Member.Type.PROPERTY)) {
            return true;
        }
        ModifierGroup getterModifiers = variable.accept(new Visibility.ModifiersFinder(Visibility.CheckType.CALLER_READ), null);
        if (variable.getDefiningType().getUnitType() == UnitType.TRIGGER) {
            return variable.getDefiningType().equals(accessingType);
        }
        return variable.getModifiers().has(ModifierTypeInfos.STATIC) && variable.getModifiers().some(ModifierTypeInfos.GLOBAL, ModifierTypeInfos.PUBLIC) && Visibility.isMemberVisibleNoTestCheck(accessingType, variable.getDefiningType(), getterModifiers, true);
    }
}

