/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility;

import apex.jorje.semantic.bcl.validators.JavaSfdcOnlyAnnotation;
import apex.jorje.semantic.common.initializer.Initializer;
import apex.jorje.semantic.common.initializer.Initializers;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.MethodTableFactory;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.StandardTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.tester.TestMethods;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ObjectArrays;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class JavaSfdcOnlyVisibilityTest {
    private static final Initializer<MethodTable, TypeInfo> JAVA_SFDC_ONLY_TEST_METHODS = Initializers.memoize(type -> MethodTableFactory.create(TestMethods.globalStatic(type).setReturnType(TypeInfos.VOID).setName("isAllowOnlyInTesting").setJavaSfdcOnlyAnnotation(JavaSfdcOnlyAnnotation.builder().setAllowOnlyInTesting().build()).build(), TestMethods.globalStatic(type).setReturnType(TypeInfos.VOID).setName("isAllowOnlyInRealTesting").setJavaSfdcOnlyAnnotation(JavaSfdcOnlyAnnotation.builder().setAllowOnlyInRealTesting().build()).build(), TestMethods.globalStatic(type).setReturnType(TypeInfos.VOID).setName("isAllowOnlyInTestingAndIsAllowTrustedApplication").setJavaSfdcOnlyAnnotation(JavaSfdcOnlyAnnotation.builder().setAllowOnlyInTesting().setAllowTrustedApplications().build()).build(), TestMethods.globalStatic(type).setReturnType(TypeInfos.VOID).setName("isAllowOnlyInRealTestingAndIsAllowTrustedApplication").setJavaSfdcOnlyAnnotation(JavaSfdcOnlyAnnotation.builder().setAllowOnlyInRealTesting().setAllowTrustedApplications().build()).build(), TestMethods.globalStatic(type).setReturnType(TypeInfos.VOID).setName("isAllowTesting").setJavaSfdcOnlyAnnotation(JavaSfdcOnlyAnnotation.DEFAULT_ALLOW_TESTING).build(), TestMethods.globalStatic(type).setReturnType(TypeInfos.VOID).setName("isNone").setJavaSfdcOnlyAnnotation(JavaSfdcOnlyAnnotation.builder().setDisallowTesting().build()).build(), TestMethods.globalStatic(type).setReturnType(TypeInfos.VOID).setName("isAllowInternalSfdc").setJavaSfdcOnlyAnnotation(JavaSfdcOnlyAnnotation.builder().setAllowInternalSfdc().build()).build(), TestMethods.globalStatic(type).setReturnType(TypeInfos.VOID).setName("isAllowTrustedApplications").setJavaSfdcOnlyAnnotation(JavaSfdcOnlyAnnotation.builder().setAllowTrustedApplications().build()).build(), TestMethods.globalStatic(type).setReturnType(TypeInfos.VOID).setName("isAllowInApexFiles").setJavaSfdcOnlyAnnotation(JavaSfdcOnlyAnnotation.builder().setAllowInApexFiles().build()).build(), TestMethods.globalStatic(type).setReturnType(TypeInfos.VOID).setName("isAllowPrivate").setJavaSfdcOnlyAnnotation(JavaSfdcOnlyAnnotation.builder().setAllowPrivate().build()).build()));
    private static final StandardTypeInfo JAVA_SFDC_ONLY_TEST = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("JavaSfdcOnlyTest")).setNamespace(Namespaces.SYSTEM)).setMethods(JAVA_SFDC_ONLY_TEST_METHODS)).setUnitType(UnitType.CLASS)).setBasicType(BasicType.APEX_OBJECT)).build();
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
        this.tester.getSymbolProvider().addAdditionalTypes(JAVA_SFDC_ONLY_TEST);
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"Account a; a.addError('foo', 'bar');", I18nSupport.getLabel("method.not.visible", "void Account.addError(String, String)")}, {"Account a; a.addError('foo', 'bar', true);", I18nSupport.getLabel("method.not.visible", "void Account.addError(String, String, Boolean)")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return ObjectArrays.concat(this.sfdcOrAllowTestingOrTrustedApplicationOrPrivate(), this.sfdcOrAllowTesting(), Object[].class);
    }

    @DataProvider
    Object[][] sfdcOrAllowTestingOrTrustedApplicationOrPrivate() {
        return new Object[][]{{"Account a; a.getActiveRecordTypes();"}, {"Account a; a.getActiveRecordTypesByName();"}};
    }

    @DataProvider
    Object[][] sfdcOrAllowTesting() {
        return new Object[][]{{"Account a; a.addError('foo', 'bar');"}, {"Account a; a.addError('foo', 'bar', true);"}};
    }

    @Test(dataProvider="validData")
    public void testSfdc(String code) {
        this.tester.getAccessEvaluator().setIsSfdc(true);
        this.tester.assertSuccess(code);
    }

    @Test(dataProvider="validData")
    public void testAllowTesting(String code) {
        this.tester.getAccessEvaluator().setIsRunningTests(true);
        this.tester.assertSuccess(code);
    }

    @Test(dataProvider="sfdcOrAllowTestingOrTrustedApplicationOrPrivate")
    public void testTrustedApplication(String code) {
        this.tester.getAccessEvaluator().setIsTrustedApplication(true);
        this.tester.assertSuccess(code);
    }

    @Test(dataProvider="sfdcOrAllowTestingOrTrustedApplicationOrPrivate")
    public void testPrivate(String code) {
        this.tester.getAccessEvaluator().setHasLocalizedTranslation(true).setHasPrivateApi(true);
        this.tester.assertSuccess(code);
    }

    @Test
    public void testIsAllowOnlyInTestingPasses() {
        this.tester.getAccessEvaluator().setIsRunningTests(true);
        this.tester.assertSuccess("JavaSfdcOnlyTest.isAllowOnlyInTesting();");
    }

    @Test
    public void testIsAllowOnlyInTestingFails() {
        this.tester.getAccessEvaluator().setIsTrustedApplication(true);
        this.tester.assertFailure("JavaSfdcOnlyTest.isAllowOnlyInTestingAndIsAllowTrustedApplication();", I18nSupport.getLabel("method.not.visible", "void JavaSfdcOnlyTest.isAllowOnlyInTestingAndIsAllowTrustedApplication()"));
    }

    @Test
    public void testIsAllowOnlyInRealTestingPasses() {
        this.tester.getAccessEvaluator().setIsReallyRunningTests(true).setIsSfdc(true);
        this.tester.assertSuccess("JavaSfdcOnlyTest.isAllowOnlyInRealTesting();");
    }

    @Test
    public void testIsAllowOnlyInRealTestingFails() {
        this.tester.getAccessEvaluator().setIsTrustedApplication(true);
        this.tester.assertFailure("JavaSfdcOnlyTest.isAllowOnlyInRealTestingAndIsAllowTrustedApplication();", I18nSupport.getLabel("method.not.visible", "void JavaSfdcOnlyTest.isAllowOnlyInRealTestingAndIsAllowTrustedApplication()"));
    }

    @Test
    public void testIsAllowTestingPasses() {
        this.tester.getAccessEvaluator().setIsRunningTests(true);
        this.tester.assertSuccess("JavaSfdcOnlyTest.isAllowTesting();");
    }

    @Test
    public void testIsNoneFails() {
        this.tester.assertFailure("JavaSfdcOnlyTest.isNone();", I18nSupport.getLabel("method.not.visible", "void JavaSfdcOnlyTest.isNone()"));
    }

    @Test
    public void testAllowInternalSfdcPasses() {
        this.tester.getAccessEvaluator().setHasInternalSfdc(true);
        this.tester.assertSuccess("JavaSfdcOnlyTest.isAllowInternalSfdc();");
    }

    @Test
    public void testIsAllowInternalSfdcFails() {
        this.tester.assertFailure("JavaSfdcOnlyTest.isAllowInternalSfdc();", I18nSupport.getLabel("method.not.visible", "void JavaSfdcOnlyTest.isAllowInternalSfdc()"));
    }

    @Test
    public void testIsAllowTrustedApplicationsPasses() {
        this.tester.getAccessEvaluator().setIsTrustedApplication(true);
        this.tester.assertSuccess("JavaSfdcOnlyTest.isAllowTrustedApplications();");
    }

    @Test
    public void testIsAllowTrustedApplicationsFails() {
        this.tester.assertFailure("JavaSfdcOnlyTest.isAllowTrustedApplications();", I18nSupport.getLabel("method.not.visible", "void JavaSfdcOnlyTest.isAllowTrustedApplications()"));
    }

    @Test
    public void testIsAllowInApexFilesPasses() {
        this.tester.getAccessEvaluator().setAccessibleSystemNamespace(Namespaces.EMPTY);
        this.tester.assertSuccess("JavaSfdcOnlyTest.isAllowInApexFiles();");
    }

    @Test
    public void testIsAllowInApexFilesFails() {
        this.tester.assertFailure("JavaSfdcOnlyTest.isAllowInApexFiles();", I18nSupport.getLabel("method.not.visible", "void JavaSfdcOnlyTest.isAllowInApexFiles()"));
    }

    @Test
    public void testIsAllowPrivatePasses() {
        this.tester.getAccessEvaluator().setHasPrivateApi(true).setHasLocalizedTranslation(true);
        this.tester.assertSuccess("JavaSfdcOnlyTest.isAllowPrivate();");
    }

    @Test
    public void testIsAllowPrivateFailsNoLocalizedTranslation() {
        this.tester.getAccessEvaluator().setHasPrivateApi(true);
        this.tester.assertFailure("JavaSfdcOnlyTest.isAllowPrivate();", I18nSupport.getLabel("method.not.visible", "void JavaSfdcOnlyTest.isAllowPrivate()"));
    }

    @Test
    public void testIsAllowPrivateFailsNoPrivateApi() {
        this.tester.getAccessEvaluator().setHasLocalizedTranslation(true);
        this.tester.assertFailure("JavaSfdcOnlyTest.isAllowPrivate();", I18nSupport.getLabel("method.not.visible", "void JavaSfdcOnlyTest.isAllowPrivate()"));
    }

    @Test
    public void testIsAllowPrivateFailsNoAnything() {
        this.tester.assertFailure("JavaSfdcOnlyTest.isAllowPrivate();", I18nSupport.getLabel("method.not.visible", "void JavaSfdcOnlyTest.isAllowPrivate()"));
    }
}

