/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.reference;

import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.reference.TypeReference;
import com.google.common.base.Preconditions;

public class TypeReferences {
    public static final TypeRef.ClassTypeRef GENERATED_TYPE_REF = new TypeRef.ClassTypeRef(null, null, null);

    private TypeReferences() {
    }

    public static TypeReference createResolved(TypeInfo type) {
        return new ResolvedTypeRef(type);
    }

    public static TypeReference createResolvable(TypeRef typeRef) {
        return new ResolvableTypeRef(typeRef);
    }

    private static class ResolvableTypeRef
    implements TypeReference {
        private final TypeRef typeRef;
        private TypeInfo type;

        public ResolvableTypeRef(TypeRef typeRef) {
            this.typeRef = typeRef;
        }

        @Override
        public TypeInfo resolve(SymbolResolver symbols, TypeInfo definingType) {
            return this.type == null ? (this.type = symbols.lookupTypeInfo(definingType, this.typeRef)) : this.type;
        }

        @Override
        public TypeInfo get() {
            Preconditions.checkNotNull(this.type);
            return this.type;
        }

        @Override
        public TypeRef getRef() {
            return this.typeRef;
        }

        public String toString() {
            return this.type.toString();
        }
    }

    private static class ResolvedTypeRef
    implements TypeReference {
        private final TypeInfo type;

        private ResolvedTypeRef(TypeInfo type) {
            this.type = type;
        }

        @Override
        public TypeInfo resolve(SymbolResolver symbols, TypeInfo definingType) {
            return this.type;
        }

        public String toString() {
            return this.type.toString();
        }

        @Override
        public TypeInfo get() {
            return this.type;
        }

        @Override
        public TypeRef getRef() {
            return GENERATED_TYPE_REF;
        }
    }
}

