/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import apex.jorje.semantic.symbol.type.parent.StandardParentTable;
import apex.jorje.semantic.tester.matchers.IsType;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class StandardParentTableTest {
    private static final boolean IGNORED = false;
    private static final Set<TypeInfo> NO_INTERFACES = Collections.emptySet();
    @Mock
    private TypeInfo interfaceType;
    @Mock
    private TypeInfo superType;
    @Mock
    private TypeInfo superInterfaceType;
    @Mock
    private ParentTable interfaceParents;
    @Mock
    private ParentTable superParents;
    private ParentTable parents;

    @BeforeMethod
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.interfaceType.parents()).thenReturn((Object)this.interfaceParents);
        Mockito.when((Object)this.interfaceParents.isResolved()).thenReturn((Object)true);
        Mockito.when((Object)this.superType.parents()).thenReturn((Object)this.superParents);
        Mockito.when((Object)this.superParents.isResolved()).thenReturn((Object)true);
        this.parents = new StandardParentTable();
    }

    @Test(expectedExceptions={AssertionError.class})
    public void superIsResolved() {
        Mockito.when((Object)this.superParents.isResolved()).thenReturn((Object)false);
        this.parents.resolve(this.superType, NO_INTERFACES, false);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void interfaceIsResolved() {
        Mockito.when((Object)this.interfaceParents.isResolved()).thenReturn((Object)false);
        this.parents.resolve(null, ImmutableSet.of(this.interfaceType), false);
    }

    @Test
    public void shouldCheckSuperVisibility() {
        this.parents.resolve(null, NO_INTERFACES, true);
        MatcherAssert.assertThat((Object)this.parents.isResolved(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.parents.checkSuperVisibility(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldNotCheckSuperVisibility() {
        this.parents.resolve(null, NO_INTERFACES, false);
        MatcherAssert.assertThat((Object)this.parents.isResolved(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.parents.checkSuperVisibility(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void none() {
        this.parents.resolve(null, NO_INTERFACES, false);
        MatcherAssert.assertThat(this.parents.allInterfaces(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.parents.immediateInterfaces(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)this.parents.superType(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.parents.isResolved(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void superNoImplementations() {
        this.parents.resolve(this.superType, NO_INTERFACES, false);
        MatcherAssert.assertThat(this.parents.allInterfaces(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.parents.immediateInterfaces(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)this.parents.superType(), IsType.isType(this.superType));
        MatcherAssert.assertThat((Object)this.parents.isResolved(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void superWithImplementations() {
        Mockito.when(this.superParents.allInterfaces()).thenReturn(ImmutableSet.of(this.interfaceType));
        this.parents.resolve(this.superType, NO_INTERFACES, false);
        MatcherAssert.assertThat(this.parents.allInterfaces(), (Matcher)Matchers.containsInAnyOrder((Object[])new TypeInfo[]{this.interfaceType}));
        MatcherAssert.assertThat(this.parents.immediateInterfaces(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)this.parents.superType(), IsType.isType(this.superType));
        MatcherAssert.assertThat((Object)this.parents.isResolved(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void interfaceNoExtends() {
        this.parents.resolve(null, ImmutableSet.of(this.interfaceType), false);
        MatcherAssert.assertThat(this.parents.allInterfaces(), (Matcher)Matchers.containsInAnyOrder((Object[])new TypeInfo[]{this.interfaceType}));
        MatcherAssert.assertThat(this.parents.immediateInterfaces(), (Matcher)Matchers.containsInAnyOrder((Object[])new TypeInfo[]{this.interfaceType}));
        MatcherAssert.assertThat((Object)this.parents.superType(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.parents.isResolved(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void interfaceWithExtends() {
        Mockito.when(this.interfaceParents.allInterfaces()).thenReturn(ImmutableSet.of(this.superInterfaceType));
        this.parents.resolve(null, ImmutableSet.of(this.interfaceType), false);
        MatcherAssert.assertThat(this.parents.allInterfaces(), (Matcher)Matchers.containsInAnyOrder((Object[])new TypeInfo[]{this.interfaceType, this.superInterfaceType}));
        MatcherAssert.assertThat(this.parents.immediateInterfaces(), (Matcher)Matchers.containsInAnyOrder((Object[])new TypeInfo[]{this.interfaceType}));
        MatcherAssert.assertThat((Object)this.parents.superType(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.parents.isResolved(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void superAndInterface() {
        this.parents.resolve(this.superType, ImmutableSet.of(this.interfaceType), false);
        MatcherAssert.assertThat(this.parents.allInterfaces(), (Matcher)Matchers.contains((Object[])new TypeInfo[]{this.interfaceType}));
        MatcherAssert.assertThat(this.parents.immediateInterfaces(), (Matcher)Matchers.contains((Object[])new TypeInfo[]{this.interfaceType}));
        MatcherAssert.assertThat((Object)this.parents.superType(), IsType.isType(this.superType));
        MatcherAssert.assertThat((Object)this.parents.isResolved(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void superWithImplementationsAndInterface() {
        Mockito.when(this.superParents.allInterfaces()).thenReturn(ImmutableSet.of(this.interfaceType));
        this.parents.resolve(this.superType, ImmutableSet.of(this.interfaceType), false);
        MatcherAssert.assertThat(this.parents.allInterfaces(), (Matcher)Matchers.containsInAnyOrder((Object[])new TypeInfo[]{this.interfaceType}));
        MatcherAssert.assertThat(this.parents.immediateInterfaces(), (Matcher)Matchers.containsInAnyOrder((Object[])new TypeInfo[]{this.interfaceType}));
        MatcherAssert.assertThat((Object)this.parents.superType(), IsType.isType(this.superType));
        MatcherAssert.assertThat((Object)this.parents.isResolved(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void superWithImplementationsAndInterfaceWithExtends() {
        Mockito.when(this.interfaceParents.allInterfaces()).thenReturn(ImmutableSet.of(this.superInterfaceType));
        Mockito.when(this.superParents.allInterfaces()).thenReturn(ImmutableSet.of(this.interfaceType));
        this.parents.resolve(this.superType, ImmutableSet.of(this.interfaceType), false);
        MatcherAssert.assertThat(this.parents.allInterfaces(), (Matcher)Matchers.containsInAnyOrder((Object[])new TypeInfo[]{this.interfaceType, this.superInterfaceType}));
        MatcherAssert.assertThat(this.parents.immediateInterfaces(), (Matcher)Matchers.containsInAnyOrder((Object[])new TypeInfo[]{this.interfaceType}));
        MatcherAssert.assertThat((Object)this.parents.superType(), IsType.isType(this.superType));
        MatcherAssert.assertThat((Object)this.parents.isResolved(), (Matcher)Matchers.is((Object)true));
    }
}

