/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.TestConstants;
import apex.jorje.semantic.tester.ValidationTester;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import java.util.List;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ScopeSanityTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] validNamespaceData() {
        return new Object[][]{{Lists.newArrayList("global class A extends NamespaceB.B {}"), Lists.newArrayList("global abstract class B implements C {}", "global interface C {}")}, {Lists.newArrayList("global class A extends NamespaceB.B {}"), Lists.newArrayList("global abstract class B implements C.A {}", "global class C { public interface A{} }")}};
    }

    @Test(dataProvider="validNamespaceData")
    public void testValidNamespaceData(List<String> sourcesInNamespaceA, List<String> sourcesInNamespaceB) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccesses(((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)ImmutableListMultimap.builder().putAll((Object)TestConstants.NAMESPACE_A, sourcesInNamespaceA)).putAll((Object)TestConstants.NAMESPACE_B, sourcesInNamespaceB)).build());
    }
}

