/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.parent.ParentTableFactory;
import apex.jorje.semantic.symbol.type.parent.TypeInfoTester;
import apex.jorje.semantic.tester.TestSymbolResolvers;
import apex.jorje.semantic.tester.matchers.ErrorMatchers;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.LinkedListMultimap;
import org.hamcrest.MatcherAssert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ResolveOnceTest {
    private SymbolResolver symbols;

    @BeforeMethod
    public final void setUp() {
        this.symbols = TestSymbolResolvers.createTestSymbols();
    }

    @Test
    public void testResolveOnce() {
        TypeInfo interfaceBarExtendsFoo = TypeInfoTester.createInterfaceBarExtendsFoo();
        TypeInfo interfaceFooExtendsBar = TypeInfoTester.createInterfaceFooExtendsBar();
        this.symbols.add(interfaceBarExtendsFoo);
        this.symbols.add(interfaceFooExtendsBar);
        LinkedListMultimap<TypeInfo, CompilationException> errors = LinkedListMultimap.create();
        ParentTableFactory.resolve(errors, this.symbols, interfaceBarExtendsFoo);
        ParentTableFactory.resolve(errors, this.symbols, interfaceFooExtendsBar);
        ParentTableFactory.resolve(errors, this.symbols, interfaceBarExtendsFoo);
        MatcherAssert.assertThat(errors, ErrorMatchers.containsMultiErrors(I18nSupport.getLabel("circular.definition", interfaceBarExtendsFoo), I18nSupport.getLabel("circular.definition", interfaceFooExtendsBar)));
    }
}

