/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.jorje.data.CompilationUnitBuilder;
import apex.jorje.data.JadtTester;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.parent.ParentTableCalculatorTest;
import apex.jorje.semantic.tester.TestTypeInfos;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class IllegalArrayRefTest
extends ParentTableCalculatorTest {
    private TypeInfo createClassBarExtendsStringArray() {
        return TestTypeInfos.create(CompilationUnitBuilder.builder((String)"bar").setSuperType(JadtTester.arrayRef((TypeRef)JadtTester.type((String)"String", (String[])new String[0]))).buildClass());
    }

    private TypeInfo createClassBarImplementsStringArray() {
        return TestTypeInfos.create(CompilationUnitBuilder.builder((String)"bar").setInterfaces(new TypeRef[]{JadtTester.arrayRef((TypeRef)JadtTester.type((String)"String", (String[])new String[0]))}).buildClass());
    }

    private TypeInfo createInterfaceBarExtendsStringArray() {
        return TestTypeInfos.create(CompilationUnitBuilder.builder((String)"bar").setSuperType(JadtTester.arrayRef((TypeRef)JadtTester.type((String)"String", (String[])new String[0]))).buildInterface());
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"illegal array ref for parents", this.createClassBarExtendsStringArray(), ImmutableList.of(), ImmutableList.of(I18nSupport.getLabel("array.ref.not.allowed", "String[]"))}, {"illegal array ref for parents", this.createClassBarImplementsStringArray(), ImmutableList.of(), ImmutableList.of(I18nSupport.getLabel("array.ref.not.allowed", "String[]"))}, {"illegal array ref for parents", this.createInterfaceBarExtendsStringArray(), ImmutableList.of(), ImmutableList.of(I18nSupport.getLabel("array.ref.not.allowed", "String[]"))}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String message, TypeInfo type, List<TypeInfo> additionalTypes, List<String> expectedErrors) {
        this.assertInvalid(message, type, additionalTypes, expectedErrors);
    }
}

