/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.jorje.data.CompilationUnitBuilder;
import apex.jorje.data.JadtTester;
import apex.jorje.data.ast.Modifier;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.parent.ParentTableCalculatorTest;
import apex.jorje.semantic.symbol.type.parent.TypeInfoTester;
import apex.jorje.semantic.tester.TestTypeInfos;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ExceptionExtendsTest
extends ParentTableCalculatorTest {
    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"exception not extending exception", this.createExceptionWithoutSuperType(), ImmutableList.of(), ImmutableList.of(I18nSupport.getLabel("invalid.exception.must.extend.exception", "FooException"))}, {"exception not extending exception", this.createExceptionWithoutExceptionSuperType(), ImmutableList.of(TypeInfoTester.CLASS_FOO), ImmutableList.of(I18nSupport.getLabel("invalid.exception.must.extend.exception", "Foo"))}, {"exception not ending in exception", this.createExceptionWithoutExceptionSuffix(), ImmutableList.of(), ImmutableList.of(I18nSupport.getLabel("invalid.exception.must.end.with.exception", "Foo"))}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String message, TypeInfo type, List<TypeInfo> additionalTypes, List<String> expectedErrors) {
        this.assertInvalid(message, type, additionalTypes, expectedErrors);
    }

    private TypeInfo createExceptionWithoutExceptionSuffix() {
        return TestTypeInfos.create(CompilationUnitBuilder.builder((String)"Foo").setSuperType(JadtTester.type((String)"Exception", (String[])new String[0])).buildClass());
    }

    private TypeInfo createExceptionWithoutExceptionSuperType() {
        return TestTypeInfos.create(CompilationUnitBuilder.builder((String)"FooException").setSuperType(JadtTester.type((String)"Foo", (String[])new String[0])).buildClass());
    }

    private TypeInfo createExceptionWithoutSuperType() {
        return TestTypeInfos.create(CompilationUnitBuilder.builder((String)"FooException").buildClass());
    }

    @Test
    public void testException() {
        TypeInfo exceptionFoo = this.createFooException();
        this.assertValid(exceptionFoo, Collections.emptyList(), (Matcher<Iterable<? extends TypeInfo>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends TypeInfo>>)Matchers.emptyIterable(), InternalTypeInfos.APEX_EXCEPTION);
    }

    @Test
    public void testExceptionExtendsUserException() {
        TypeInfo exceptionFoo = this.createFooException();
        TypeInfo exceptionBarExtendsExceptionFoo = this.createBarExtendsFooException();
        this.assertValid(exceptionBarExtendsExceptionFoo, ImmutableList.of(exceptionFoo), (Matcher<Iterable<? extends TypeInfo>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends TypeInfo>>)Matchers.emptyIterable(), exceptionFoo);
    }

    @Test
    public void testBaseException() {
        this.assertValid(TypeInfoTester.createApexException(), Collections.emptyList(), (Matcher<Iterable<? extends TypeInfo>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends TypeInfo>>)Matchers.emptyIterable(), TypeInfos.EXCEPTION);
    }

    private TypeInfo createFooException() {
        return TestTypeInfos.create(CompilationUnitBuilder.builder((String)"FooException").setSuperType(JadtTester.type((String)"Exception", (String[])new String[0])).setModifiers(new Modifier[]{Modifier._VirtualModifier(JadtTester.NO_LOC)}).buildClass());
    }

    private TypeInfo createBarExtendsFooException() {
        return TestTypeInfos.create(CompilationUnitBuilder.builder((String)"BarException").setSuperType(JadtTester.type((String)"FooException", (String[])new String[0])).buildClass());
    }
}

