/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.parent.ParentTableCalculatorTest;
import apex.jorje.semantic.symbol.type.parent.TypeInfoTester;
import apex.jorje.semantic.tester.matchers.IsType;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DuplicateGenericInterfaceTest
extends ParentTableCalculatorTest {
    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"class with duplicate interface through inheritance", TypeInfoTester.createClassBazExtendsBarImplementsFooInteger(), ImmutableList.of(TypeInfoTester.createClassBarImplementsFooType("String"), TypeInfoTester.INTERFACE_FOO_U), ImmutableList.of(I18nSupport.getLabel("generic.interface.already.implemented", TypeInfoTester.INTERFACE_FOO))}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String message, TypeInfo type, List<TypeInfo> additionalTypes, List<String> expectedErrors) {
        this.assertInvalid(message, type, additionalTypes, expectedErrors);
    }

    @Test
    public void testValidIfSameReifiedInterface() {
        TypeInfo type = TypeInfoTester.createClassBazExtendsBarImplementsFooInteger();
        TypeInfo superType = TypeInfoTester.createClassBarImplementsFooType("Integer");
        ImmutableList<TypeInfo> additionalTypes = ImmutableList.of(superType, TypeInfoTester.INTERFACE_FOO_U);
        GenericTypeInfo interfaceFooInteger = GenericTypeInfoFactory.create((TypeInfo)TypeInfoTester.INTERFACE_FOO_U, TypeInfos.INTEGER);
        this.assertValid(type, additionalTypes, IsType.containsTypes(interfaceFooInteger, interfaceFooInteger), IsType.containsTypes(interfaceFooInteger), superType);
    }
}

