/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.jorje.data.CompilationUnitBuilder;
import apex.jorje.data.JadtTester;
import apex.jorje.data.ast.Modifier;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.parent.ParentTableCalculatorTest;
import apex.jorje.semantic.symbol.type.parent.TypeInfoTester;
import apex.jorje.semantic.tester.TestTypeInfos;
import apex.jorje.semantic.tester.matchers.IsType;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ClassImplementsGenericInterfaceTest
extends ParentTableCalculatorTest {
    private TypeInfo createClassBarImplementsFooFoo() {
        return TestTypeInfos.create(CompilationUnitBuilder.builder((String)"Bar").setInterfaces(new TypeRef[]{JadtTester.type((String)"Foo", (String[])new String[]{"Integer", "String"}), JadtTester.type((String)"Foo", (String[])new String[]{"Integer", "String"})}).setModifiers(new Modifier[]{Modifier._VirtualModifier(JadtTester.NO_LOC)}).buildClass());
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"class with type arguments for not parameterized interface", TypeInfoTester.createClassBarImplementsGenericFoo(), ImmutableList.of(TypeInfoTester.CLASS_BAZ, TypeInfoTester.INTERFACE_FOO), ImmutableList.of(I18nSupport.getLabel("type.arguments.for.non.parameterized.type", TypeInfoTester.INTERFACE_FOO))}, {"class with unresolved arguments for parameterized interface", TypeInfoTester.createClassBarImplementsGenericFoo(), ImmutableList.of(TypeInfoTester.INTERFACE_FOO_U_T), ImmutableList.of(I18nSupport.getLabel("invalid.unresolved.type", TypeInfoTester.CLASS_BAZ))}, {"class with mismatch arguments for parameterized interface", TypeInfoTester.createClassBarImplementsGenericFoo(), ImmutableList.of(TypeInfoTester.CLASS_BAZ, TypeInfoTester.INTERFACE_FOO_U), ImmutableList.of(I18nSupport.getLabel("invalid.parameterized.type.count", TypeInfoTester.INTERFACE_FOO_U, 1, 2))}, {"class with no type arguments for parameterized interface", TypeInfoTester.createClassBarImplementsFoo(), ImmutableList.of(TypeInfoTester.CLASS_BAZ, TypeInfoTester.INTERFACE_FOO_U_T), ImmutableList.of(I18nSupport.getLabel("no.type.arguments.for.parameterized.type", TypeInfoTester.INTERFACE_FOO_U_T))}, {"class with duplicate parameterized interface", this.createClassBarImplementsFooFoo(), Collections.singletonList(TypeInfoTester.INTERFACE_FOO_U_T), Collections.singletonList(I18nSupport.getLabel("interface.already.implemented", "Foo<Integer, String>"))}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String message, TypeInfo type, List<TypeInfo> additionalTypes, List<String> expectedErrors) {
        this.assertInvalid(message, type, additionalTypes, expectedErrors);
    }

    @Test
    public void testClassWithGenericInterface() {
        TypeInfo classBarExtendsParameterizedFoo = TypeInfoTester.createClassBarImplementsGenericFoo();
        GenericTypeInfo classFooBazString = GenericTypeInfo.builder().setUnreifiedType(TypeInfoTester.INTERFACE_FOO_U_T).setTypeArguments(TypeInfoTester.CLASS_BAZ, TypeInfos.STRING).build();
        this.assertValid(classBarExtendsParameterizedFoo, ImmutableList.of(TypeInfoTester.CLASS_BAZ, TypeInfoTester.INTERFACE_FOO_U_T), IsType.containsTypes(classFooBazString), IsType.containsTypes(classFooBazString), InternalTypeInfos.APEX_OBJECT);
    }
}

