/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.jorje.data.CompilationUnitBuilder;
import apex.jorje.data.JadtTester;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.parent.ParentTableCalculatorTest;
import apex.jorje.semantic.symbol.type.parent.TypeInfoTester;
import apex.jorje.semantic.tester.TestStandardTypeInfos;
import apex.jorje.semantic.tester.TestTypeInfos;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ClassExtendsTest
extends ParentTableCalculatorTest {
    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"class with bad super type", TypeInfoTester.createClassBarExtendsFoo(), ImmutableList.of(TypeInfoTester.INTERFACE_FOO), ImmutableList.of(I18nSupport.getLabel("invalid.class", TypeInfoTester.INTERFACE_FOO))}, {"class with unresolved super type", TypeInfoTester.createClassBarExtendsFoo(), ImmutableList.of(), ImmutableList.of(I18nSupport.getLabel("invalid.unresolved.type", TypeInfoTester.CLASS_FOO))}, {"class with unresolved interface", TypeInfoTester.createClassBarImplementsFoo(), ImmutableList.of(), ImmutableList.of(I18nSupport.getLabel("invalid.unresolved.type", TypeInfoTester.INTERFACE_FOO))}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String message, TypeInfo type, List<TypeInfo> additionalTypes, List<String> expectedErrors) {
        this.assertInvalid(message, type, additionalTypes, expectedErrors);
    }

    @Test
    public void testClass() {
        TypeInfo classFoo = TestTypeInfos.create(CompilationUnitBuilder.emptyClass((String)"Foo"));
        this.assertValid(classFoo, Collections.emptyList(), (Matcher<Iterable<? extends TypeInfo>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends TypeInfo>>)Matchers.emptyIterable(), TestStandardTypeInfos.APEX_OBJECT);
    }

    @Test
    public void testBaseClass() {
        TypeInfo apexObject = TypeInfoTester.createApexObject();
        this.assertValid(apexObject, Collections.emptyList(), (Matcher<Iterable<? extends TypeInfo>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends TypeInfo>>)Matchers.emptyIterable(), TypeInfos.OBJECT);
    }

    @Test
    public void testClassWithSuperType() {
        TypeInfo classBarExtendsFoo = TypeInfoTester.createClassBarExtendsFoo();
        this.assertValid(classBarExtendsFoo, ImmutableList.of(TypeInfoTester.CLASS_FOO), (Matcher<Iterable<? extends TypeInfo>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends TypeInfo>>)Matchers.emptyIterable(), TypeInfoTester.CLASS_FOO);
    }

    @Test
    public void testClassWithSuperTypeWithInterface() {
        TypeInfo classBarImplementsFoo = TypeInfoTester.createClassBarImplementsFoo();
        TypeInfo classBazExtendsBar = TestTypeInfos.create(CompilationUnitBuilder.builder((String)"Baz").setSuperType(JadtTester.type((String)"Bar", (String[])new String[0])).buildClass());
        this.assertValid(classBazExtendsBar, ImmutableList.of(TypeInfoTester.INTERFACE_FOO, classBarImplementsFoo), (Matcher<Iterable<? extends TypeInfo>>)Matchers.contains((Object[])new TypeInfo[]{TypeInfoTester.INTERFACE_FOO}), (Matcher<Iterable<? extends TypeInfo>>)Matchers.emptyIterable(), classBarImplementsFoo);
    }
}

