/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.naming;

import apex.jorje.semantic.common.iterable.LessStrings;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TypeNameParser {
    private static final CharMatcher IDENTIFIER = CharMatcher.DIGIT.or(CharMatcher.is('/')).or(CharMatcher.is('_')).or(CharMatcher.is('.')).or(CharMatcher.is('$')).or(CharMatcher.inRange('a', 'z')).or(CharMatcher.inRange('A', 'Z'));
    private final String typeName;
    private final String separator;
    private final String left;
    private final String right;
    private final Splitter splitter;
    private int depth;
    private int index = 0;

    private TypeNameParser(String typeName, Splitter splitter, String separator, String left, String right) {
        this.typeName = typeName;
        this.splitter = splitter;
        this.depth = 0;
        this.separator = separator;
        this.left = left;
        this.right = right;
    }

    public static TypeName parseBytecodeName(String bytecodeName) {
        return new TypeNameParser(bytecodeName, new BytecodeNameSplitter(), "$$c", "$$l", "$$r").parse();
    }

    public static TypeName parseApexName(String apexName) {
        return new TypeNameParser(apexName, new ApexNameSplitter(), ",", "<", ">").parse();
    }

    private String identifier() {
        StringBuilder builder = new StringBuilder();
        while (this.index < this.typeName.length() && IDENTIFIER.matches(this.typeName.charAt(this.index)) && !this.isDelimiter(this.left) && !this.isDelimiter(this.right) && !this.isDelimiter(this.separator)) {
            builder.append(this.typeName.charAt(this.index));
            ++this.index;
        }
        return builder.toString();
    }

    private boolean isDelimiter(String delimiter) {
        if (this.index + delimiter.length() - 1 >= this.typeName.length()) {
            return false;
        }
        for (int i = 0; i < delimiter.length(); ++i) {
            if (this.typeName.charAt(this.index + i) == delimiter.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private TypeName parse() {
        ImmutableList.Builder typeArguments = ImmutableList.builder();
        String typeName = this.identifier();
        TypeName.Info info = this.splitter.split(typeName);
        boolean currentTypeArguments = false;
        while (this.index < this.typeName.length()) {
            if (this.isDelimiter(this.left)) {
                this.index += this.left.length();
                currentTypeArguments = true;
                ++this.depth;
                typeArguments.add(this.parse());
                continue;
            }
            if (this.isDelimiter(this.right)) {
                if (currentTypeArguments) {
                    this.index += this.right.length();
                    break;
                }
                if (this.depth > 0) {
                    --this.depth;
                    break;
                }
                throw new IllegalArgumentException("Invalid type name: " + this.typeName);
            }
            if (this.isDelimiter(this.separator)) {
                if (currentTypeArguments) {
                    this.index += this.separator.length();
                    typeArguments.add(this.parse());
                    continue;
                }
                if (this.depth > 0) break;
                throw new IllegalArgumentException("Invalid type name: " + this.typeName);
            }
            throw new IllegalArgumentException("Invalid type name: " + this.typeName);
        }
        return new TypeName(info, typeName, (List<TypeName>)((Object)typeArguments.build()));
    }

    private static class ApexNameSplitter
    implements Splitter {
        private static final Pattern APEX_NAME = Pattern.compile("((\\w+)\\.)?((\\w+)\\.)?(\\w+)");

        private ApexNameSplitter() {
        }

        @Override
        public TypeName.Info split(String value) {
            Matcher matcher = APEX_NAME.matcher(value);
            if (matcher.find()) {
                String namespace = MoreObjects.firstNonNull(matcher.group(2), "");
                return new TypeName.Info(namespace, matcher.group(4), matcher.group(5));
            }
            return null;
        }
    }

    private static class BytecodeNameSplitter
    implements Splitter {
        private static final Pattern BYTECODE_NAME = Pattern.compile("((\\w+)/)?((\\w+)/)?((\\w+)\\$)?(\\w+)");

        private BytecodeNameSplitter() {
        }

        @Override
        public TypeName.Info split(String value) {
            Matcher matcher = BYTECODE_NAME.matcher(value);
            if (matcher.find()) {
                String namespace = MoreObjects.firstNonNull(matcher.group(2), "");
                namespace = MoreObjects.firstNonNull(matcher.group(4), namespace);
                return new TypeName.Info(namespace, matcher.group(6), matcher.group(7));
            }
            return null;
        }
    }

    public static class TypeName {
        public final Info info;
        public final String name;
        public final List<TypeName> arguments;

        public TypeName(String name, TypeName ... arguments) {
            this(null, name, Arrays.asList(arguments));
        }

        public TypeName(Info info, String name, List<TypeName> arguments) {
            this.info = info;
            this.name = name;
            this.arguments = arguments;
        }

        public int hashCode() {
            return Objects.hashCode(this.name, this.arguments);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeName typeName = (TypeName)o;
            return Objects.equal(this.name, typeName.name) && Objects.equal(this.arguments, typeName.arguments);
        }

        public String toString() {
            return TypeNameUtil.createBytecodeName(this.name, LessStrings.toString(this.arguments));
        }

        public static class Info {
            public final String namespace;
            public final String enclosingName;
            public final String className;

            public Info(String namespace, String enclosingName, String className) {
                this.namespace = namespace;
                this.enclosingName = enclosingName;
                this.className = className;
            }

            public String getTopLevelName() {
                return MoreObjects.firstNonNull(this.enclosingName, this.className);
            }
        }
    }

    private static interface Splitter {
        public TypeName.Info split(String var1);
    }
}

