/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.naming;

import apex.jorje.data.CompilationUnitBuilder;
import apex.jorje.data.ast.BlockMember;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.semantic.common.iterator.Pair;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.naming.TypeNameFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TypeNameFactoryTest {
    private static final Namespace SOME_NAMESPACE = Namespaces.create("Global", "Module");
    private static final Namespace SOME_OTHER_NAMESPACE = Namespaces.create("Global", "");
    private static final SourceFile NAMESPACE_SOURCE = SourceFile.builder().setBody("").setNamespace(SOME_NAMESPACE).build();
    private static final SourceFile SOURCE = SourceFile.builder().setBody("").setNamespace(Namespaces.EMPTY).build();
    private static final SourceFile FLOW_SOURCE = SourceFile.builder().setBody("").setNamespace(Namespaces.create(Namespaces.FLOW.toString(), "Interview")).build();
    private static final SourceFile NAMESPACE_FLOW_SOURCE = SourceFile.builder().setBody("").setNamespace(Namespaces.create(Namespaces.FLOW.toString(), "Interview." + SOME_OTHER_NAMESPACE)).build();
    private static final TypeInfo NO_TYPE = null;
    private static final TypeInfo NAMESPACE_ENCLOSING_TYPE = ((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setFileBase(NAMESPACE_SOURCE, CompilationUnitBuilder.emptyClass((String)"Parent"))).build();
    private static final TypeInfo ENCLOSING_TYPE = ((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setFileBase(SOURCE, CompilationUnitBuilder.emptyClass((String)"Parent"))).build();
    private static final CompilationUnit CLASS = CompilationUnitBuilder.emptyClass((String)"Foo");
    private static final CompilationUnit INTERFACE = CompilationUnitBuilder.emptyInterface((String)"Foo");
    private static final CompilationUnit ENUM = CompilationUnitBuilder.emptyEnum((String)"Foo");
    private static final CompilationUnit TRIGGER = CompilationUnitBuilder.emptyTrigger((String)"Foo");
    private static final CompilationUnit ANONYMOUS = CompilationUnitBuilder.anonymous((BlockMember[])new BlockMember[0]);
    private Pair<String, String> name;

    @DataProvider
    Object[][] compilationUnitData() {
        return new Object[][]{{CLASS}, {INTERFACE}, {ENUM}};
    }

    @Test(dataProvider="compilationUnitData")
    public void testStandardType(CompilationUnit unit) {
        this.name = TypeNameFactory.create(NAMESPACE_SOURCE, NAMESPACE_ENCLOSING_TYPE, unit);
        this.assertName("Global.Parent.Foo", "Global/Parent$Foo", this.name);
        this.name = TypeNameFactory.create(SOURCE, ENCLOSING_TYPE, unit);
        this.assertName("Parent.Foo", "Parent$Foo", this.name);
        this.name = TypeNameFactory.create(NAMESPACE_SOURCE, NO_TYPE, unit);
        this.assertName("Global.Foo", "Global/Foo", this.name);
        this.name = TypeNameFactory.create(SOURCE, NO_TYPE, unit);
        this.assertName("Foo", "Foo", this.name);
    }

    @Test
    public void testTrigger() {
        this.name = TypeNameFactory.create(NAMESPACE_SOURCE, NO_TYPE, TRIGGER);
        this.assertName("Global.Foo", "__sfdc_trigger/Global/Foo", this.name);
        this.name = TypeNameFactory.create(SOURCE, NO_TYPE, TRIGGER);
        this.assertName("Foo", "__sfdc_trigger/Foo", this.name);
    }

    @Test
    public void testFlowWithoutNamespace() {
        this.name = TypeNameFactory.create(FLOW_SOURCE, NO_TYPE, CLASS);
        this.assertName("Flow.Interview.Foo", "Flow/Interview/Foo", this.name);
    }

    @Test
    public void testFlowWithNamespace() {
        this.name = TypeNameFactory.create(NAMESPACE_FLOW_SOURCE, NO_TYPE, CLASS);
        this.assertName("Flow.Interview.Global.Foo", "Flow/Interview/Global/Foo", this.name);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testTriggerCannotBeInnerType() {
        TypeNameFactory.create(NAMESPACE_SOURCE, NAMESPACE_ENCLOSING_TYPE, TRIGGER);
    }

    @Test
    public void testAnonymous() {
        this.name = TypeNameFactory.create(NAMESPACE_SOURCE, NO_TYPE, ANONYMOUS);
        this.assertName("anon", "anon", this.name);
        this.name = TypeNameFactory.create(SOURCE, NO_TYPE, ANONYMOUS);
        this.assertName("anon", "anon", this.name);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testAnonymousCannotBeInnerType() {
        TypeNameFactory.create(NAMESPACE_SOURCE, NAMESPACE_ENCLOSING_TYPE, ANONYMOUS);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testEnclosingTypeDifferentNamespace() {
        TypeNameFactory.create(NAMESPACE_SOURCE, ENCLOSING_TYPE, CLASS);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testInnerTypeDifferentNamespace() {
        TypeNameFactory.create(SOURCE, NAMESPACE_ENCLOSING_TYPE, CLASS);
    }

    private void assertName(String apexName, String bytecodeName, Pair<String, String> name) {
        MatcherAssert.assertThat((String)"wrong apexName", name.left, (Matcher)Matchers.is((Object)apexName));
        MatcherAssert.assertThat((String)"wrong bytecodeName", name.right, (Matcher)Matchers.is((Object)bytecodeName));
    }
}

