/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.common;

import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.WrapperTypeInfos;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TypeInfoUtilTest {
    @Mock
    private TypeInfo type;
    @Mock
    private TypeInfo enclosingType;
    @Mock
    private ModifierGroup modifiers;
    @Mock
    private ModifierGroup enclosingModifiers;

    @BeforeMethod
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.type.getModifiers()).thenReturn((Object)this.modifiers);
        Mockito.when((Object)this.enclosingType.getModifiers()).thenReturn((Object)this.enclosingModifiers);
    }

    @DataProvider
    Object[][] isFastCallTypeData() {
        return new Object[][]{{TypeInfos.INTEGER, false}, {TypeInfos.LIST, true}, {TypeInfos.LIST, true}, {TypeInfos.SET, true}, {TypeInfos.SET, true}, {TypeInfos.MAP, true}, {WrapperTypeInfos.SYSTEM_LIST_ITERATOR, true}};
    }

    @Test(dataProvider="isFastCallTypeData")
    public void testIsFastCallType(TypeInfo type, boolean expected) {
        MatcherAssert.assertThat((Object)TypeInfoUtil.isFastCallType(type), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testIsTestClass() {
        Mockito.when((Object)this.modifiers.isTest()).thenReturn((Object)true);
        MatcherAssert.assertThat((Object)TypeInfoUtil.isTestClass(this.type), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testIsInnerClassOfNonTest() {
        Mockito.when((Object)this.type.getEnclosingType()).thenReturn((Object)this.enclosingType);
        MatcherAssert.assertThat((Object)TypeInfoUtil.isTestClass(this.type), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsInnerClassOfTest() {
        Mockito.when((Object)this.modifiers.isTest()).thenReturn((Object)false);
        Mockito.when((Object)this.enclosingModifiers.isTest()).thenReturn((Object)true);
        Mockito.when((Object)this.type.getEnclosingType()).thenReturn((Object)this.enclosingType);
        Mockito.when((Object)this.enclosingType.getModifiers()).thenReturn((Object)this.enclosingModifiers);
        MatcherAssert.assertThat((Object)TypeInfoUtil.isTestClass(this.type), (Matcher)Matchers.is((Object)true));
    }
}

